<?php
declare(strict_types=1);

namespace FiloBlu\Storelocator\Model;

use FiloBlu\Storelocator\Model\ResourceModel\Events\CollectionFactory;
use FiloBlu\Core\Framework\Model\RepositoryItem;
use FiloBlu\Storelocator\Api\Data\EventsInterface;
use Magento\Framework\DataObject;

/**
 *
 */
class Events extends DataObject implements EventsInterface
{
    /**
     * @var
     */
    protected $eventsCollectionFactory;

    /**
     * @param $id
     * @return RepositoryItem
     */
    public function setId($id): RepositoryItem
    {
        $this->setData(self::EVENT_ID, $id);
        return $this;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->getData(self::EVENT_ID);
    }

    /**
     * @param $country
     * @return RepositoryItem
     */
    public function setCountry($country): RepositoryItem
    {
        $this->setData(self::COUNTRY, $country);
        return $this;
    }

    /**
     * @return string
     */
    public function getCountry():string
    {
        return $this->getData(self::COUNTRY);
    }

    /**
     * @param $name
     * @return DataObject
     */
    public function loadByEventName($name): DataObject
    {
        $collection = $this->eventsCollectionFactory->create();
        $collection->addFieldToFilter('name', $name);

        return $collection->getFirstItem();
    }

    /**
     * @param $externalId
     * @return EventsInterface|null
     */
    public function loadByExternalEventId($externalId)
    {
        $collection = $this->eventsCollectionFactory->create();
        $collection->addFieldToFilter('external_event_id', $externalId);

        return $collection->getFirstItem();
    }
}
