<?php

namespace FiloBlu\Storelocator\Model\Config\Backend;

use Magento\Framework\App\Config\Value;

use function is_array;

/**
 * @api
 * @since 100.0.2
 */
class Serialized extends Value
{
    /**
     * @return $this
     */
    public function beforeSave()
    {
        if (is_array($this->getValue())) {
            $this->setValue(serialize($this->getValue()));
        }
        return parent::beforeSave();
    }

    /**
     * @return void
     */
    protected function _afterLoad()
    {
        if (!is_array($this->getValue())) {
            $value = $this->getValue();
            $this->setValue(empty($value) ? false : unserialize($value));
        }
    }
}
