<?php

namespace FiloBlu\Storelocator\Controller\PickUpInStore;


use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Magento\Rma\Model\Rma;
use Magento\Rma\Model\RmaFactory;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Rmarefused extends Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;
    /**
     * @var \FiloBlu\Storelocator\Helper\Data
     */
    protected $helper;
    /**
     * @var \Magento\Framework\Registry
     */
    protected $registry;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var \Magento\Rma\Model\RmaFactory
     */
    private $rmaFactory;


    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Data $helper
     * @param RmaFactory $rmaFactory
     * @param Registry $registry
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Data $helper,
        RmaFactory $rmaFactory,
        Registry $registry,
        StoreManagerInterface $storeManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->helper = $helper;
        $this->rmaFactory = $rmaFactory;
        $this->registry = $registry;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|\Magento\Framework\View\Result\Page|void
     */
    public function execute()
    {
        $rmaId = $this->getRequest()->getParam('rma_id');
        $hash = $this->getRequest()->getParam('hash');
        $storeId = $this->storeManager->getStore()->getId();

        if (!$this->helper->getPickupInStoreEnabled($storeId) || !$hash | !$rmaId) {
             $this->_forward('noRoute');
             return;
        }

        $rma = $this->rmaFactory->create();
        $rma->load($rmaId);
        $order = $rma->getOrder();

        if ($order->getId() && $rma->getReturnToStoreHash() == $hash && (int)$rma->getReturnToStoreId() > 0) {
            $this->registry->register('pickupinstore_rma_refused', $rma);
            $resultPage = $this->resultPageFactory->create();
            $resultPage->getConfig()->getTitle()->set(
                'PickUp In Store - Confirmation of rejected of the package for return ' . $rma->getData('increment_id')
            );

            return $resultPage;
        } else {
            $this->_forward('noRoute');
        }
    }
}
