<?php

namespace FiloBlu\Storelocator\Controller\Adminhtml\Stores;

use Exception;
use FiloBlu\Storelocator\Model\Google\Api;
use FiloBlu\Storelocator\Model\StoresFactory;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;

/**
 *
 */
class SendGmb extends Action
{
    /**
     * @var \FiloBlu\Storelocator\Model\Google\Api
     */
    protected $googleApi;
    /**
     * @var \FiloBlu\Storelocator\Model\StoresFactory
     */
    private $storesFactory;

    /**
     * @param Context $context
     * @param Api $googleApi
     * @param \FiloBlu\Storelocator\Model\StoresFactory $storesFactory
     */
    public function __construct(Context $context, Api $googleApi, StoresFactory $storesFactory)
    {
        $this->googleApi = $googleApi;
        parent::__construct($context);
        $this->storesFactory = $storesFactory;
    }

    /**
     * Delete action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->storesFactory->create();
                $model->load($id);
                if ($model->getGmbLocationName()) {
                    //                    $objReturn = $this->_googleApi->getLocation($store->getGmbLocationName());
                    //                    $this->messageManager->addNotice(__('StoreID:' . $store->getId() . " already exists on Google My Business"));
                    $objReturn = $this->googleApi->updateLocation($model->getGmbLocationName(), $model);

                    if (!is_string($objReturn)) {
                        $this->messageManager->addNotice(
                            __('StoreID:' . $model->getId() . ' updated on Google My Business')
                        );
                    } else {
                        $this->messageManager->addError(
                            __('Error updating StoreID:' . $model->getId() . ' - Message: ' . $objReturn)
                        );
                    }
                } else {
                    $objReturn = $this->googleApi->createLocation($model);

                    if (!is_string($objReturn)) {
                        $model->setGmbLocationName($objReturn->getName());
                        $model->save();
                        $this->messageManager->addSuccess(
                            __('StoreID:' . $model->getId() . ' created on Google My Business')
                        );
                    } else {
                        $this->messageManager->addError(
                            __('Error for StoreID:' . $model->getId() . ' - Message: ' . $objReturn)
                        );
                    }
                }


                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            } catch (Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            }
        }
        $this->messageManager->addError(__('We can\'t find a store to update gmb data.'));
        return $resultRedirect->setPath('*/*/edit', ['id' => $this->getRequest()->getParam('id')]);
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Storelocator::storelocator_save');
    }

}
