<?php

namespace FiloBlu\Storelocator\Controller\Adminhtml\Stores;

use FiloBlu\Storelocator\Model\Google\Api;
use FiloBlu\Storelocator\Model\ResourceModel\Stores\CollectionFactory;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Ui\Component\MassAction\Filter;

use function is_string;

/**
 * Class MassRemoveGmb
 */
class MassRemoveGmb extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var Filter
     */
    protected $filter;

    /**
     * @var CollectionFactory
     */
    protected $collectionFactory;
    /**
     * @var \FiloBlu\Storelocator\Model\Google\Api
     */
    protected $_googleApi;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface|null
     */
    protected $config = null;

    /**
     * @param Context $context
     * @param \Magento\Ui\Component\MassAction\Filter $filter
     * @param \FiloBlu\Storelocator\Model\ResourceModel\Stores\CollectionFactory $collectionFactory
     * @param \FiloBlu\Storelocator\Model\Google\Api $googleApi
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $config
     */
    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        Api $googleApi,
        ScopeConfigInterface $config
    ) {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->_googleApi = $googleApi;
        $this->config = $config;


        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute()
    {
        if (!$this->config->getValue('filoblu_storelocator_section/google_my_business/gmb_enabled')) {
            $this->messageManager->addError(__('Google My Business Integration is not enabled'));
            return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setPath('*/*/');
        }

        if ($this->_googleApi->getClient()->isAccessTokenExpired()) {
            $this->messageManager->addError(
                __(
                    'Access token expired. Please go to [ System -> Configuration -> FiloBlu -> Storelocator -> Google My Business ] to login in'
                )
            );
            return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setPath('*/*/');
        }

        $collection = $this->filter->getCollection($this->collectionFactory->create());

        foreach ($collection as $store) {
            if ($store->getGmbLocationName()) {
                $objReturn = $this->_googleApi->deleteLocation($store->getGmbLocationName());

                if (is_string($objReturn)) {
                    $this->messageManager->addError(
                        __('Error deleting StoreID:' . $store->getId() . ' - Message: ' . $objReturn)
                    );
                } else {
                    $this->messageManager->addSuccess(
                        __('StoreID:' . $store->getId() . ' deleted from Google My Business')
                    );
                }
            } else {
                $this->messageManager->addNotice(
                    __(
                        'Error for StoreID:' . $store->getId(
                        ) . ' - Never sent to Google My Business, nothing to do'
                    )
                );
            }

            $store->setGmbLocationName(null);
            $store->save();
        }


        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setPath('*/*/');
    }

    /**
     * Is the user allowed to view the store grid.
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Storelocator::storelocator');
    }
}
