<?php

namespace FiloBlu\Storelocator\Controller\Adminhtml\Images;

use FiloBlu\Storelocator\Model\ImagesFactory;
use Magento\Backend\App\Action;
use Magento\Backend\Model\View\Result\Page;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;

/**
 *
 */
class Edit extends Action
{
    /**
     * Core registry
     *
     * @var Registry
     */
    protected $registry = null;

    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var \FiloBlu\Storelocator\Model\ImagesFactory
     */
    private $imagesFactory;

    /**
     * @param Action\Context $context
     * @param PageFactory $resultPageFactory
     * @param \FiloBlu\Storelocator\Model\ImagesFactory $imagesFactory
     * @param Registry $registry
     */
    public function __construct(
        Action\Context $context,
        PageFactory $resultPageFactory,
        ImagesFactory $imagesFactory,
        Registry $registry
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->registry = $registry;
        parent::__construct($context);
        $this->imagesFactory = $imagesFactory;
    }

    /**
     * Edit Storelocator store
     *
     * @return Page|Redirect
     * @SuppressWarnings(PHPMD.NPathComplexity)
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('image_id');

        $model = $this->imagesFactory->create();

        if ($id) {
            $model->load($id);
            if (!$model->getId()) {
                $this->messageManager->addError(__('This image no longer exists.'));
                /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();

                return $resultRedirect->setPath('*/*/');
            }
        }

        $data = $this->_getSession()->getFormData(true);
        if (!empty($data)) {
            $model->setData($data);
        }

        $this->registry->register('storelocator_image', $model);

        /** @var Page $resultPage */
        $resultPage = $this->_initAction();
        $resultPage->addBreadcrumb(
            $id ? __('Edit Storelocator Image') : __('New Storelocator Image'),
            $id ? __('Edit Storelocator Image') : __('New Storelocator Image')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Storelocator Image'));
        $resultPage->getConfig()->getTitle()
            ->prepend($model->getId() ? $model->getTitle() : __('New Storelocator Image'));

        return $resultPage;
    }

    /**
     * Init actions
     *
     * @return Page
     */
    protected function _initAction()
    {
        // load layout, set active menu and breadcrumbs
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('FiloBlu_Storelocator::storelocator_imagenew')
            ->addBreadcrumb(__('Storelocator'), __('Storelocator'))
            ->addBreadcrumb(__('Manage Storelocator Image'), __('Manage Storelocator Image'));
        return $resultPage;
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Storelocator::storelocator_save');
    }
}