<?php

namespace FiloBlu\Storelocator\Block\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\DeploymentConfig;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class ConfirmReceived
 * @package FiloBlu\Storelocator\Block\PickUpInStore
 */
class ConfirmReceived extends Template
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var Registry
     */
    protected $registry;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var Http
     */
    protected $request;

    /**
     * @var DeploymentConfig
     */
    protected $deploymentConfig;

    /**
     * ConfirmReceived constructor.
     * @param Context $context
     * @param Data $helper
     * @param Registry $registry
     * @param Http $request
     * @param DeploymentConfig $deploymentConfig
     */
    public function __construct(
        Context $context,
        Data $helper,
        Registry $registry,
        Http $request,
        DeploymentConfig $deploymentConfig
    ) {
        parent::__construct($context);
        $this->helper = $helper;
        $this->registry = $registry;
        $this->storeManager = $context->getStoreManager();
        $this->request = $request;
        $this->deploymentConfig = $deploymentConfig;
    }

    /**
     * @return bool
     */
    public function isAlreadyConfirmed()
    {
        if ($this->request->getParam('rma_id')) {
            return $this->registry->registry('pickupinstore_order_confirm_received')->getReturnToStoreReceivedDate(
                ) != null;
        }

        return $this->registry->registry('pickupinstore_order_confirm_received')->getPickupInStoreConfirmReceivedDate(
            ) != null;
    }

    /**
     * @return string
     * @throws NoSuchEntityException
     */
    public function getBaseUrl()
    {
        return $this->storeManager->getStore()->getBaseUrl();
    }

    /**
     * @param $route
     * @param $params
     * @return array|string|string[]
     * @throws \Magento\Framework\Exception\FileSystemException
     * @throws \Magento\Framework\Exception\RuntimeException
     */
    public function getUrl($route = '', $params = [])
    {
        $url = parent::getUrl($route, $params);

        return str_replace($this->deploymentConfig->get('backend/frontName') . '/', '', $url);
    }

    /**
     * @return string
     */
    public function getParams()
    {
        if ($params = $this->getRequest()->getParams()) {
            $incrementId = $params['increment_id'] ?? '';
            $hash = $params['hash'] ?? '';
            $rma_id = isset($params['rma_id']) ? "&rma_id={$params['rma_id']}" : '';
            return 'increment_id=' . $incrementId . '&hash=' . $hash . $rma_id;
        } else {
            return '';
        }
    }

    /**
     * @return bool
     */
    public function getOrderStatus()
    {
        $order = $this->registry->registry('pickupinstore_order_confirm_received');

        if ($order) {
            return (!in_array($order->getStatus(), ['complete', 'shipped', 'complete_in_store', 'delivered_in_store']));
        }

        return false;
    }
}
