<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Tags\Edit;

use FiloBlu\Storelocator\Block\Adminhtml\Stores\Helper\Editor;
use FiloBlu\Storelocator\Block\Adminhtml\Stores\Helper\Image;
use FiloBlu\Storelocator\Model\Tags;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Magento\Store\Model\System\Store;

/**
 * Adminhtml storelocator tag edit form
 */
class Form extends Generic
{


	/**
	 * @param Context $context
	 * @param Registry $registry
	 * @param FormFactory $formFactory
	 * @param array $data
	 */
	public function __construct(
		Context     $context,
		Registry    $registry,
		FormFactory $formFactory,
		array       $data = []
	)
	{
		parent::__construct($context, $registry, $formFactory, $data);
	}

	/**
	 * Init form
	 *
	 * @return void
	 */
	protected function _construct()
	{
		parent::_construct();
		$this->setId('storelocator_tag_form');
		$this->setTitle(__('Tag Information'));
	}

	/**
	 * Prepare form
	 *
	 * @return $this
	 * @throws LocalizedException
	 */
	protected function _prepareForm()
	{
		/** @var Tags $model */
		$model = $this->_coreRegistry->registry('storelocator_tag');

		$form = $this->_formFactory->create(
			['data' => ['id' => 'edit_form', 'action' => $this->getData('action'), 'method' => 'post', 'enctype' => 'multipart/form-data',]]
		);

		$form->setHtmlIdPrefix('storelocator_tag_');

		// ## General Information ##
		$fieldset = $form->addFieldset(
			'base_fieldset',
			['legend' => __('General Information'), 'class' => 'fieldset-wide']
		);

		$fieldset->addType('image', Image::class);

		if ($model->getTagId()) {
			$fieldset->addField('tag_id', 'hidden', ['name' => 'tag_id']);
		}

		$fieldset->addField(
			'name',
			'text',
			[
				'name'     => 'name',
				'label'    => __('Name'),
				'title'    => __('Name'),
				'required' => true
			]
		);

		$fieldset->addField(
			'enabled',
			'select',
			[
				'label'    => __('Status'),
				'title'    => __('Status'),
				'name'     => 'enabled',
				'required' => true,
				'options'  => ['1' => __('Enabled'), '0' => __('Disabled')]
			]
		);

		if (!$model->getId()) {
			$model->setData('enabled', '1');
		}

		$fieldset->addField(
			'description',
			Editor::class,
			[
				'name'  => 'description',
				'label' => __('Description'),
				'title' => __('Description'),
			]
		);

		$fieldset->addField(
			'image',
			'image',
			[
				'name'  => 'image',
				'label' => __('Image'),
				'title' => __('Image')
			]
		);

		$form->setValues($model->getData());
		$form->setUseContainer(true);
		$this->setForm($form);

		return parent::_prepareForm();
	}
}