<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Images;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Form\Container;
use Magento\Framework\Phrase;
use Magento\Framework\Registry;

/**
 *
 */
class Edit extends Container
{
    /**
     * Core registry
     *
     * @var Registry
     */
    protected $_coreRegistry = null;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_coreRegistry = $registry;
    }

    /**
     * Retrieve text for header element depending on loaded store
     *
     * @return Phrase
     */
    public function getHeaderText()
    {
        if ($this->_coreRegistry->registry('storelocator_image')->getId()) {
            return __(
                "Edit Image '%1'",
                $this->escapeHtml($this->_coreRegistry->registry('storelocator_image')->getName())
            );
        }
        return __('New Image');
    }

    /**
     * Initialize store edit block
     *
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_objectId = 'image_id';
        $this->_blockGroup = 'FiloBlu_Storelocator';
        $this->_controller = 'adminhtml_images';

        parent::_construct();

        if ($this->_isAllowedAction('FiloBlu_Storelocator::storelocator_save')) {
            $this->buttonList->update('save', 'label', __('Save Image'));
            $this->buttonList->add(
                'saveandcontinue',
                [
                    'label' => __('Save and Continue Edit'),
                    'class' => 'save',
                    'data_attribute' => [
                        'mage-init' => [
                            'button' => ['event' => 'saveAndContinueEdit', 'target' => '#edit_form'],
                        ],
                    ]
                ],
                -100
            );
        } else {
            $this->buttonList->remove('save');
        }

        if ($this->_isAllowedAction('FiloBlu_Storelocator::storelocator_delete')) {
            $this->buttonList->update('delete', 'label', __('Delete Image'));
        } else {
            $this->buttonList->remove('delete');
        }
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }

    /**
     * Getter of url for "Save and Continue" button
     * tab_id will be replaced by desired by JS later
     *
     * @return string
     */
    protected function _getSaveAndContinueUrl()
    {
        return $this->getUrl(
            'filoblustorelocatoradmin/*/save',
            ['_current' => true, 'back' => 'edit', 'active_tab' => '']
        );
    }
}