<?php
namespace FiloBlu\Storelocator\Api;


/**
 * Interface PickUpInStoreManagementInterface
 * @package FiloBlu\Storelocator\Api
 */
interface PickUpInStoreManagementInterface
{
    /** @var string */
    const XML_CONFIG_PICKUP_IN_STORE_ENABLED = 'carriers/pickupinstore/active';
    /** @var string */
    const EVENT_PICKUP_IN_STORE_CONFIRM = 'filoblu_storelocator_pickupinstore_confirm';
    /** @var string */
    const EVENT_PICKUP_IN_STORE_CONFIRM_RECEIVED = 'filoblu_storelocator_pickupinstore_confirm_received';
    /** @var string */
    const STATUS_COMPLETE_IN_STORE = 'complete_in_store';
    /** @var string */
    const STATUS_DELIVERED_IN_STORE = 'delivered_in_store';

    /**
     * @param string $hash
     * @return void
     */
    public function confirm(string $hash);

    /**
     * @param string $hash
     * @return void
     */
    public function confirmReceived(string $hash);

    /**
     * @param string $hash
     * @return bool
     */
    public function checkConfirmed(string $hash): bool;

    /**
     * @param string $hash
     * @return bool
     */
    public function checkReceived(string $hash): bool;

    /**
     * @param string $hash
     * @return bool
     */
    public function checkCompleted(string $hash): bool;
}
