<?php
declare(strict_types=1);

namespace FiloBlu\Storelocator\Api\Data;

use FiloBlu\Core\Framework\Model\RepositoryItem;

/**
 * @package FiloBlu\Storelocator\Api\Data
 */
interface EventsInterface extends RepositoryItem
{
    /** @var string  */
    const STORE_ID = 'store_id';
    /** @var string  */
    const EVENT_ID = 'event_id';
    /** @var string  */
    const COUNTRY = 'country';
    /** @var string  */
    const EXTERNAL_EVENT_ID = 'external_event_id';
    /** @var string */
    const CATEGORY_ID = 'category_id';
    /** @var string */
    const NAME = 'name';
    /** @var string */
    const START = 'start';
    /** @var string */
    const END = 'end';
    /** @var string */
    const LAST_UPDATE = 'last_update';
    /** @var string */
    const ROW_ID = 'event_id';

    /**
     * @param string|null $country
     * @return \FiloBlu\Core\Framework\Model\RepositoryItem
     */
    public function setCountry($country) : RepositoryItem;

    /**
     * @return string|null
     */
    public function getCountry();
}
