define(
  [
    'jquery',
    'ko',
    'uiComponent',
    'Magento_Checkout/js/model/quote',
    'async',
    'Magento_Ui/js/modal/modal',
    'FiloBlu_Storelocator/js/model/selected-store-data',
    'filoblustorelocator'
  ],
  function($, ko, Component, quote, async, modal, selectedStoreData) {
    'use strict';
    return Component.extend({

      initObservable: function() {

          this.selectedMethod = ko.computed(function() {

          var method = quote.shippingMethod();
          var selectedMethod = method != null ? method.method_code : null;

           if (this.popup && this.oldMethodSelected != "pickupinstore"  && selectedMethod == "pickupinstore" && $('#selected-store-id').val() == 0) {
             this.openGoogleMapModal();
           }

           this.oldMethodSelected = selectedMethod;

          return selectedMethod;

        }, this);

        this.selectedStoreData = selectedStoreData;

        return this;
      },
      onElementRender: function() {

        var that = this;

        // Because ko methods are inside a modal
        $('.filoblu-storelocator-container').applyBindings();

        this.initGoogleMapModal();
        this.initGoogleMap();

        var region = '';

        if (window.checkoutConfig.pickup_in_store.current_selected_store_data.region) {
          region = ', ' + window.checkoutConfig.pickup_in_store.current_selected_store_data.region;
        }

        var currentSelectedStoreData = {
          store_id: window.checkoutConfig.pickup_in_store.current_selected_store_data.store_id,
          title: window.checkoutConfig.pickup_in_store.current_selected_store_data.title,
          email: window.checkoutConfig.pickup_in_store.current_selected_store_data.email,
          street: window.checkoutConfig.pickup_in_store.current_selected_store_data.street,
          postcode: window.checkoutConfig.pickup_in_store.current_selected_store_data.postcode,
          city: window.checkoutConfig.pickup_in_store.current_selected_store_data.city,
          region: window.checkoutConfig.pickup_in_store.current_selected_store_data.region,
          region_id: window.checkoutConfig.pickup_in_store.current_selected_store_data.region_id,
          country_id: window.checkoutConfig.pickup_in_store.current_selected_store_data.country,
          phone: window.checkoutConfig.pickup_in_store.current_selected_store_data.phone_1,
          address: '</br>' + window.checkoutConfig.pickup_in_store.current_selected_store_data.street + '</br>' + window.checkoutConfig.pickup_in_store.current_selected_store_data.postcode + ' ' + window.checkoutConfig.pickup_in_store.current_selected_store_data.city + region + ' (' + window.checkoutConfig.pickup_in_store.current_selected_store_data.country + ')'
        };

        selectedStoreData(currentSelectedStoreData);

      },
      openGoogleMapModal: function() {
        this.popup.modal('openModal');
      },
      initGoogleMapModal: function() {
        this.popup = $('.filoblu-storelocator-container');
        this.popup.modal({
          modalClass: 'storelocator-wrapper-popup-container',
          buttons: []
        });
      },
      initGoogleMap: function() {
        async.load(
          window.checkoutConfig.pickup_in_store.google_map_script_src,
          requirejs,
          function() {
            window.FiloBlu.StoreLocator.initGMap(window.checkoutConfig.pickup_in_store.google_map_config);
          }.bind(this), {
            isBuild: false
          }
        );
      },
      canShowButtons: function() {
        return (window.checkoutConfig.pickup_in_store.gmaps_search_country_enabled || window.checkoutConfig.pickup_in_store.gmaps_search_autocomplete_enabled);
      },
      isCountryEnabled: function() {
        return (window.checkoutConfig.pickup_in_store.gmaps_search_country_enabled);
      },
      isCityEnabled: function() {
        return (window.checkoutConfig.pickup_in_store.gmaps_search_country_enabled && window.checkoutConfig.pickup_in_store.gmaps_search_city_enabled);
      },
      isAutocompleteEnabled: function() {
        return (window.checkoutConfig.pickup_in_store.gmaps_search_autocomplete_enabled);
      },
      isTagEnabled: function() {
        return (window.checkoutConfig.pickup_in_store.gmaps_search_tag_enabled);
      },
      isDirectionsEnabled: function() {
        return (window.checkoutConfig.pickup_in_store.gmaps_search_tag_enabled);
      }
    });
  }
);
