define([
    'jquery',
    'mage/utils/wrapper',
    'Magento_Checkout/js/model/quote',
    'Magento_Customer/js/model/customer',
    'FiloBlu_Storelocator/js/action/create-shipping-address',
    'Magento_Checkout/js/action/select-shipping-address',
    'Magento_Checkout/js/checkout-data'
], function ($, wrapper, quote, customer, createShippingAddress, selectShippingAddress, checkoutData) {
    'use strict';
    return function (setShippingInformationAction) {
        return wrapper.wrap(setShippingInformationAction, function (originalAction) {

            if (!window.checkoutConfig.pickup_in_store.enabled) {
                return originalAction();
            }

            var shippingAddress = quote.shippingAddress();

            var method = quote.shippingMethod();

            var selectedMethod = method != null ? method.method_code : null;

            var mustSetBillingAddressToNull = false;

            if (selectedMethod == "pickupinstore") {
                if ($('#selected-store-id').val() > 0) {

                    if (!quote.billingAddress() || !quote.billingAddress().street || (Array.isArray(quote.billingAddress().street) && !quote.billingAddress().street.length)) {
                        mustSetBillingAddressToNull = true;
                    }

                    var newShippingAddressData =  {
                        email: shippingAddress.email,
                        countryId: $("#selected-store-countryId").val(),
                        //regionId: $("#selected-store-region_id").val(),
                        //regionCode: (addressData.region) ? addressData.region.region_code : null,
                        region: $("#selected-store-region").val(),
                        region_id: $("#selected-store-region_id").val(),
                        region_code: "",
                        //customerId: shippingAddress.customerId,
                        street: { 0: $("#selected-store-street").val()},
                        //company: addressData.company,
                        telephone: $("#selected-store-phone").val(),
                        //fax: addressData.fax,
                        postcode: $("#selected-store-postcode").val(),
                        city: $("#selected-store-city").val(),
                        firstname: $("#selected-store-title").val(),
                        lastname: method.method_title,
                        //middlename: shippingAddress.middlename,
                        //prefix: shippingAddress.prefix,
                        //company: $("#selected-store-title").val(),
                        //vatId: shippingAddress.vat_id,
                        save_in_address_book: 0,
                        //customAttributes: addressData.custom_attributes,
                        default_shipping: 0,
                        default_billing: 0,

                    };

                    shippingAddress = createShippingAddress(newShippingAddressData);
                    selectShippingAddress(shippingAddress);
                    checkoutData.setSelectedShippingAddress(shippingAddress.getKey());
                    checkoutData.setShippingAddressFromData($.extend(true, {}, newShippingAddressData));

                    // if (customer.isLoggedIn()) {
                    //   checkoutData.setNewCustomerShippingAddress($.extend(true, {}, newShippingAddressData));
                    // }
                }
            }

            if (shippingAddress['extension_attributes'] === undefined) {
                shippingAddress['extension_attributes'] = {};
            }

            shippingAddress['extension_attributes']['selected_store_id'] = $("#selected-store-id").val();
            shippingAddress['extension_attributes']['selected_store_email'] = $("#selected-store-email").val();

            // pass functionality to original action ('Magento_Checkout/js/action/set-shipping-information')
            var original = originalAction();

            if (mustSetBillingAddressToNull) {
                quote.billingAddress(null);
            }

            return original;
        });
    };
});
