<?php

namespace FiloBlu\Storelocator\Ui\Component\Listing\Column;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 *
 */
class OrderActions extends Column
{
    const SEND_EMAIL_URL = 'filoblustorelocatoradmin/orders/sendEmail';

    /**
     * @var UrlInterface
     */
    protected $urlBuilder;
    /**
     * @var string
     */
    protected $viewUrl;
    /**
     * @var string
     */
    protected $sendEmailUrl;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param string $viewUrl
     * @param array $components
     * @param array $data
     * @param string $sendEmailUrl
     */
    public function __construct(
        ContextInterface $context ,
        UiComponentFactory $uiComponentFactory ,
        UrlInterface $urlBuilder,
        $viewUrl = '',
        array $components = [] ,
        array $data = [],
        $sendEmailUrl = self::SEND_EMAIL_URL
    )
    {
        $this->urlBuilder = $urlBuilder;
        $this->viewUrl = $viewUrl;
        $this->sendEmailUrl = $sendEmailUrl;
        parent::__construct($context , $uiComponentFactory , $components , $data);
    }

    /**
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = [
                    'send' =>  [
                        'href' => $this->urlBuilder->getUrl(
                            $this->sendEmailUrl,
                            ['id' => $item['entity_id']]
                        ),
                        'label' => __('Send Email to Store'),
                        'confirm' => [
                            'title' => __('Do you want to send e-mail for this order ?'),
                            'message' => __('Are you sure?')
                        ]
                    ]
                ];
            }
        }
        return $dataSource;
    }
}
