<?php

namespace FiloBlu\Storelocator\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        /**
         * Create table 'stores'
         */
        if (!$installer->tableExists('filoblu_storelocator_stores')) {
            $table = $installer->getConnection()->newTable(
                $installer->getTable('filoblu_storelocator_stores')
            )
                ->addColumn(
                    'store_id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'Store Id'
                )->addColumn(
                    'enabled',
                    Table::TYPE_INTEGER,
                    null,
                    ['nullable' => false, 'default' => '0'],
                    'Enabled'
                )->addColumn(
                    'title',
                    Table::TYPE_TEXT,
                    255,
                    ['nullable' => false],
                    'Title'
                )->addColumn(
                    'image',
                    Table::TYPE_TEXT,
                    255,
                    [],
                    'Image'
                )->addColumn(
                    'latitude',
                    Table::TYPE_DECIMAL,
                    '12,7',
                    ['nullable' => true],
                    'Latitude'
                )
                ->addColumn(
                    'longitude',
                    Table::TYPE_DECIMAL,
                    '12,7',
                    ['nullable' => true],
                    'Longitude'
                )->setComment(
                    'stores list'
                );
            $installer->getConnection()->createTable($table);
        }

        $installer->endSetup();
    }
}
