<?php

namespace FiloBlu\Storelocator\Controller\PickUpInStore;

use FiloBlu\Storelocator\Helper\Data;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Magento\Rma\Model\Rma;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Rmareceived extends Action
{
    /** @var \Magento\Framework\View\Result\PageFactory */
    protected $resultPageFactory;

    /** @var \FiloBlu\Storelocator\Helper\Data */
    protected $helper;

    protected $_rma;

    protected $_coreRegistry;

    protected $_order;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param Data $helper
     * @param Rma $rma
     * @param Registry $registry
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        Data $helper,
        Rma $rma,
        Registry $registry,
        StoreManagerInterface $storeManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->helper = $helper;
        $this->_rma = $rma;
        $this->_coreRegistry = $registry;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     *
     * @return \Magento\Framework\View\Result\Page
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $params = $this->getRequest()->getParams();
        $storeId = $this->storeManager->getStore()->getId();

        if ((!$this->helper->getPickupInStoreEnabled($storeId) && !$this->helper->getReturnToStoreEnabled($storeId)) || !isset($params['rma_id']) || !$params['rma_id']) {
            return $this->_forward('noRoute');
        }

        $this->_rma->load($params['rma_id']);
        $this->_order = $this->_rma->getOrder();

        $hash = isset($params['hash']) ? $params['hash'] : null;

        if ($this->_order->getId() && $this->_rma->getReturnToStoreHash(
        ) == $hash && (int)$this->_rma->getReturnToStoreId() > 0) {
            $this->_coreRegistry->register('pickupinstore_rma_received', $this->_rma);
            $resultPage = $this->resultPageFactory->create();

            $title = __('PickUp In Store - Confirmation of acceptance of the package for return ');

            if (!$this->helper->getUseStandardRmaMailFlow($storeId) && $this->_rma->getStatus() == 'pending') {
                $title = __('PickUp In Store - Confirmation of authorization of the package for return ');
            }

            $resultPage->getConfig()->getTitle()->set($title . $this->_rma->getData('increment_id'));

            return $resultPage;
        }

        return $this->_forward('noRoute');
    }
}
