<?php

namespace FiloBlu\Storelocator\Controller\Adminhtml\Stores;

use Exception;
use FiloBlu\Storelocator\Model\Google\Api;
use FiloBlu\Storelocator\Model\StoresFactory;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\Controller\ResultInterface;

/**
 *
 */
class RemoveGmb extends Action
{
    /**
     * @var \FiloBlu\Storelocator\Model\Google\Api
     */
    protected $googleApi;

    /**
     * @var \FiloBlu\Storelocator\Model\StoresFactory
     */
    private $storesFactory;

    /**
     * @param Context $context
     * @param \FiloBlu\Storelocator\Model\Google\Api $googleApi
     * @param \FiloBlu\Storelocator\Model\StoresFactory $storesFactory
     */
    public function __construct(Context $context, Api $googleApi, StoresFactory $storesFactory)
    {
        $this->googleApi = $googleApi;
        parent::__construct($context);
        $this->storesFactory = $storesFactory;
    }

    /**
     * Delete action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->storesFactory->create();
                $model->load($id);
                if ($model->getGmbLocationName()) {
                    $objReturn = $this->googleApi->deleteLocation($model->getGmbLocationName());

                    if (!is_string($objReturn)) {
                        $this->messageManager->addSuccess(
                            __('StoreID:' . $model->getId() . ' deleted from Google My Business')
                        );
                    } else {
                        $this->messageManager->addError(
                            __('Error deleting StoreID:' . $model->getId() . ' - Message: ' . $objReturn)
                        );
                    }
                } else {
                    $this->messageManager->addNotice(
                        __(
                            'Error for StoreID:' . $model->getId(
                            ) . ' - Never sent to Google My Business, nothing to do'
                        )
                    );
                }

                $model->setGmbLocationName(null);
                $model->save();


                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            } catch (Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            }
        }
        $this->messageManager->addError(__('We can\'t find a store to update gmb data.'));
        return $resultRedirect->setPath('*/*/edit', ['id' => $this->getRequest()->getParam('id')]);
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Storelocator::storelocator_delete');
    }
}
