<?php

declare(strict_types=1);

namespace FiloBlu\Storelocator\Block\System\Config\Button;

use FiloBlu\Storelocator\Model\Google\Api;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 *
 */
class GmbLogin extends Field
{
    /**
     * Path to block template
     */
    const GMB_TEMPLATE = 'system/config/button/gmb_login.phtml';
    /**
     * @var Api
     */
    private $googleApi;

    /**
     * @param Context $context
     * @param Api $googleApi
     * @param array $data
     */
    public function __construct(
        Context $context,
        Api $googleApi,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->googleApi = $googleApi;
    }

    /**
     * @return bool
     */
    public function isGoogleMyBusinessEnabled()
    {
        return $this->_scopeConfig->isSetFlag('filoblu_storelocator_section/google_my_business/gmb_enabled');
    }

    /**
     * Render button
     *
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * @return Api
     */
    public function getGoogleApi()
    {
        return $this->googleApi;
    }

    /**
     * Set template to itself
     *
     * @return $this
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        if (!$this->getTemplate()) {
            $this->setTemplate(static::GMB_TEMPLATE);
        }
        return $this;
    }

    /**
     * Get the button and scripts contents
     *
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $this->addData(
            [
                'html_id' => $element->getHtmlId(),
            ]
        );
        return $this->_toHtml();
    }
}
