<?php

namespace FiloBlu\Storelocator\Block;

use FiloBlu\Storelocator\Model\TagsFactory;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template\Context;
use FiloBlu\Storelocator\Model\StoresFactory;

/**
 *
 */
class Filter extends Main
{
    /**
     * @var TagsFactory
     */
    private $tagsFactory;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param StoresFactory $storesFactory
     * @param TagsFactory $tagsFactory
     */
    public function __construct(
        Context $context,
        Registry $registry,
        StoresFactory $storesFactory,
        TagsFactory $tagsFactory
    ) {
        parent::__construct($context, $storesFactory, $registry);
        $this->tagsFactory = $tagsFactory;
    }

    public function getAllAvailableTags()
    {
        return $this->tagsFactory->create()->getAllAvailableTags();
    }
}
