<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\System\Config\Form\Field;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory;

/**
 *
 */
class OrderStatus implements OptionSourceInterface
{
    /**
     * @var CollectionFactory
     */
    protected $collectionFactory;

    /**
     * OrderStatus constructor.
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(CollectionFactory $collectionFactory) {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $output = [];
        foreach ($this->collectionFactory->create()->getItems() as $item) {
            $output[] = [
                'label' => $item->getData('label'),
                'value' => $item->getData('status')
            ];
        }

        return $output;
    }

}