<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Stores\Grid\Renderer\Tag;

use Magento\Backend\Block\Context;
use Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Image extends AbstractRenderer
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     * @param array $data
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_authorization = $context->getAuthorization();
        $this->storeManager = $storeManager;
    }

    /**
     * @param DataObject $row
     * @return string
     * @throws NoSuchEntityException
     */
    public function render(DataObject $row)
    {
        if (!$this->_getValue($row)) {
            return '';
        }
        $mediaDirectory = $this->storeManager->getStore()->getBaseUrl(
            UrlInterface::URL_TYPE_MEDIA
        );
        $imageUrl = $mediaDirectory . '/filoblu/storelocator/stores/image' . $this->_getValue($row);
        return '<img src="' . $imageUrl . '" width="20" title="' . $this->_getValue(
                $row
            ) . '" alt="' . $this->_getValue($row) . '" "/>';
    }
}