<?php

namespace FiloBlu\Storelocator\Block\Adminhtml\Stores;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Form\Container;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Phrase;
use Magento\Framework\Registry;

/**
 *
 */
class Edit extends Container
{

    /**
     * Core registry
     *
     * @var Registry
     */
    protected $registry;

    /**
     * @var ScopeConfigInterface
     */
    private $config;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        array $data = []
    ) {
        $this->registry = $registry;
        $this->config = $context->getScopeConfig();
        parent::__construct($context, $data);
    }

    /**
     * Retrieve text for header element depending on loaded store
     *
     * @return Phrase
     */
    public function getHeaderText()
    {
        if ($this->registry->registry('storelocator_store')->getId()) {
            return __(
                "Edit Store '%1'",
                $this->escapeHtml($this->registry->registry('storelocator_store')->getTitle())
            );
        }

        return __('New Store');
    }

    /**
     * Initialize store edit block
     *
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        $this->_objectId = 'store_id';
        $this->_blockGroup = 'FiloBlu_Storelocator';
        $this->_controller = 'adminhtml_stores';

        parent::_construct();

        if ($this->_isAllowedAction('FiloBlu_Storelocator::storelocator_save')) {
            $this->buttonList->update('save', 'label', __('Save Store'));
            $this->buttonList->add(
                'saveandcontinue',
                [
                    'label'          => __('Save and Continue Edit'),
                    'class'          => 'save',
                    'data_attribute' => [
                        'mage-init' => [
                            'button' => ['event' => 'saveAndContinueEdit', 'target' => '#edit_form'],
                        ],
                    ]
                ],
                -100
            );

            if ($this->getRequest()->getParam($this->_objectId)) {
                $this->buttonList->add(
                    'geocode',
                    [
                        'label'   => __('Geocode'),
                        'onclick' => 'setLocation("' . $this->getUrl(
                                '*/*/geocode',
                                [$this->_objectId => $this->getRequest()->getParam($this->_objectId)]
                            ) . '")',
                    ],
                    1
                );

                if ($this->config->getValue('filoblu_storelocator_section/google_my_business/gmb_enabled')) {
                    $this->buttonList->add(
                        'gmbsend',
                        [
                            'label'   => __('Send Gmb'),
                            'onclick' => 'setLocation("' . $this->getUrl(
                                    '*/*/sendgmb',
                                    [$this->_objectId => $this->getRequest()->getParam($this->_objectId)]
                                ) . '")',
                        ],
                        2
                    );
                }
                if ($this->config->getValue(
                        'filoblu_storelocator_section/google_my_business/gmb_enabled'
                    ) && $this->registry->registry('storelocator_store')->getGmbLocationName()) {
                    $this->buttonList->add(
                        'gmbremove',
                        [
                            'label'   => __('Remove Gmb'),
                            'onclick' => 'setLocation("' . $this->getUrl(
                                    '*/*/removegmb',
                                    [$this->_objectId => $this->getRequest()->getParam($this->_objectId)]
                                ) . '")',
                        ],
                        3
                    );
                }
            }
        } else {
            $this->buttonList->remove('save');
        }

        if ($this->_isAllowedAction('FiloBlu_Storelocator::storelocator_delete')) {
            $this->buttonList->update('delete', 'label', __('Delete Store'));
        } else {
            $this->buttonList->remove('delete');
        }
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }

    /**
     * Getter of url for "Save and Continue" button
     * tab_id will be replaced by desired by JS later
     *
     * @return string
     */
    protected function _getSaveAndContinueUrl()
    {
        return $this->getUrl(
            'filoblustorelocatoradmin/*/save',
            ['_current' => true, 'back' => 'edit', 'active_tab' => '']
        );
    }

}
