<?php

namespace FiloBlu\StockaFix\Ui\DataProvider\Event\Modifier;

use Magento\Ui\DataProvider\Modifier\ModifierInterface;

/**
 * Class ReportOutput
 * @package FiloBlu\StockaFix\Ui\DataProvider\Event\Modifier
 */
class ReportOutput implements ModifierInterface {
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    protected $request;
    /**
     * @var \FiloBlu\StockaFix\Helper\ReportHelper
     */
    protected $reportHelper;
    /**
     * @var
     */
    protected $mapping = [];
    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;
    /**
     * @var
     */
    protected $report;
    /**
     * @var
     */
    protected $dbMeta;
    /**
     * @var
     */
    protected $params;

    /**
     * ReportOutput constructor.
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper
     * @param \Magento\Framework\UrlInterface $urlBuilder
     */
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper
    ) {
        $this->request = $request;
        $this->reportHelper = $reportHelper;
    }

    /**
     * @throws \Exception
     */
    public function prepareReportMetaData() {
        if(!empty($this->report)){
            return;
        }
        $this->report = $this->reportHelper->getReportFromRequest($this->request,'id');
        $this->dbMeta = $this->reportHelper->getReportMeta($this->report, true);
        $this->mapping = $this->reportHelper->getReportFieldMapping($this->report);
        $this->params = ['record' => $this->request->getParam('record'),'id' => $this->request->getParam('id')];
    }

    /**
     * @param array $data
     * @return array
     */
    public function modifyData(array $data)
    {
        $this->prepareReportMetaData();
        unset($data['items']);
        unset($data['totalRecords']);
        foreach($data as $key => $item) {
            foreach ($item as $fieldset => $values) {
                foreach ($values as $attribute => $val) {
                    $data[$key][$fieldset][$attribute] = $this->reportHelper->getMappedValue($this->mapping,$attribute,$val,$this->params);
                }
            }
        }

        return $data;
    }

    /**
     * {@inheritdoc}
     */
    public function modifyMeta(array $meta)
    {
        $m['general'] = [
            'arguments' => [
                'data' => [
                    'config' => [
                        'label' => __('Detail'),
                        'sortOrder' => 50,
                        'collapsible' => false
                    ]
                ]
            ],
            'children' => []
        ];

        $this->prepareReportMetaData();

        $children = [];
        foreach ($this->dbMeta as $attribute => $info) {
            if(isset($this->mapping[$attribute]['showInDetail']) && $this->mapping[$attribute]['showInDetail']==0){
                continue;
            }
            $arguments = [
                'data' => [
                    'config' =>  $this->getColumnFromMeta($info, $attribute)
                ]
            ];

            $children[$attribute]['arguments'] = $arguments;
        }

        $m['general']['children'] = $children;
        $meta = $m;
        return $meta;
    }

    /**
     * @param $column
     * @param $attribute
     * @param $report
     * @return array|void
     */
    protected function getColumnFromMeta($column, $attribute)
    {
        $type = $column['Type'];
        $label = $attribute;
        $dataScope = 'general.'.$attribute;
        $elementTmpl = 'ui/form/element/text';
        if(count($this->mapping)>0){
            if(isset($this->mapping[$attribute])){
                $label = $this->mapping[$attribute]['label'];
                if($this->mapping[$attribute]['type'] == 'file') {
                    $elementTmpl = 'FiloBlu_StockaFix/ui/form/element/download';
                }
                if($this->mapping[$attribute]['type'] == 'textarea') {
                    $elementTmpl = 'ui/form/element/html';
                }
            }
        }

        return [
            'label' => $label,
            'dataType' => 'text',
            'visible' => 1,
            'componentType' => 'field',
            'formElement' => 'textarea',
            'dataScope' => $dataScope,
            'elementTmpl' => $elementTmpl
        ];

    }

}
