<?php

namespace FiloBlu\StockaFix\Plugin\Model\Menu;

use function Symfony\Component\Console\Tests\Command\createClosure;

/**
 * Class BuilderPlugin
 * @package FiloBlu\StockaFix\Plugin\Model\Menu
 */
class BuilderPlugin
{
    /**
     * @var Menu\ItemFactory
     */
    protected $menuItemFactory;

    /**
     * @var \FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory
     */
    protected $reportCollectionFactory;

    /**
     * BuilderPlugin constructor.
     * @param \Magento\Backend\Model\Menu\ItemFactory $menuItemFactory
     * @param \FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory $reportCollectionFactory
     */
    public function __construct(
        \Magento\Backend\Model\Menu\ItemFactory $menuItemFactory,
        \FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory $reportCollectionFactory
    )
    {
        $this->menuItemFactory = $menuItemFactory;
        $this->reportCollectionFactory = $reportCollectionFactory;
    }

    /**
     * @param \Magento\Backend\Model\Menu\Builder $subject
     * @param \Magento\Backend\Model\Menu $menu
     * @return \Magento\Backend\Model\Menu
     */
    public function afterGetResult(\Magento\Backend\Model\Menu\Builder $subject,  \Magento\Backend\Model\Menu $menu)
    {
        /** @var \FiloBlu\StockaFix\Model\ResourceModel\Report\Collection $collection */
        $collection = $this->reportCollectionFactory->create();

        $collection->addFieldToSelect(['report_id', 'name', 'menu_label']);
        $collection->addFieldToFilter('menu_show', ['eq' => 1]);
        $collection->addFieldToFilter('active', ['eq' => 1]);

        foreach ( $collection->getItems() as $report )
        {   /** @var Menu\Item $item */
            $parent = 'FiloBlu_StockaFix::report_outputs';
            $reportId = $report->getId();

            $item = $this->menuItemFactory->create([
                'data' => [
                    'parent_id' => $parent,
                    'id' => 'FiloBlu_StockaFix::report' . $reportId,
                    'title' => $report->getMenuLabel(),
                    'resource' => 'FiloBlu_StockaFix::report_menu',
                    'action' => 'filoblu_stockafix/reportoutput/index/id/' . $reportId

                ]
            ]);

            $menu->add($item, $parent);
        }

        return $menu;
    }
}
