<?php

namespace FiloBlu\StockaFix\Plugin\Model;

/**
 * Class Export
 * @package FiloBlu\StockaFix\Plugin\Model
 */
class Export
{

    /**
     * @var \FiloBlu\StockaFix\Model\Report
     */
    protected $modelReport;
    /**
     * @var \Magento\Framework\Stdlib\DateTime\DateTime
     */
    private $coreDate;

    /**
     * Export constructor.
     * @param \FiloBlu\StockaFix\Model\Report $modelReport
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $coreDate
     */
    public function __construct(
        \FiloBlu\StockaFix\Model\Report $modelReport,
        \Magento\Framework\Stdlib\DateTime\DateTime $coreDate

    )
    {
        $this->modelReport = $modelReport;
        $this->coreDate = $coreDate;
    }


    /**
     * @param \Magento\ScheduledImportExport\Model\Export $subject
     * @param $result
     * @return string
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function afterGetScheduledFileName(\Magento\ScheduledImportExport\Model\Export $subject, $result)
    {
        if ($subject->getEntity() === 'filoblu_stockafix_report') {
            return $this->getSchedulerFilename($subject,$result);
        }
        return $result;
    }

    /**
     * @param $subject
     * @param $result
     * @return string|string[]
     */
    public function getSchedulerFilename($subject , $result)
    {

        $reportId = $subject->getDataByPath('export_filter/report');

        $fileName = $this->modelReport->load($reportId)->getFileName();
        if ($fileName === null) {
            return $result;
        }
        $fileName = str_replace('%d', $this->coreDate->date('Ymd_His'), $fileName);
        return $fileName;
    }

}

