<?php

namespace FiloBlu\StockaFix\Plugin\Form\Element\DataType;

use FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory;
use Magento\Framework\App\RequestInterface;

class Date
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var CollectionFactory
     */
    protected $reportCollectionFactory;

    /**
     * @param RequestInterface $request
     * @param CollectionFactory $reportCollectionFactory
     */
    public function __construct(
        RequestInterface $request,
        CollectionFactory $reportCollectionFactory
    )
    {
        $this->request = $request;
        $this->reportCollectionFactory = $reportCollectionFactory;
    }


    public function beforePrepare(\Magento\Ui\Component\Form\Element\DataType\Date $subject, $result = null) {

        $id = $this->request->getParam('id');

        if (!$id) {
            return [$result];
        }

        /** @var \FiloBlu\StockaFix\Model\Report $report */
        $report = $this->reportCollectionFactory->create()->addFieldToFilter('report_id', ['eq', $id])->getFirstItem();

        if (!$report) {
            return [$result];
        }

        $subject->setLocale($report->getDateLocale());
    }
}
