<?php

namespace FiloBlu\StockaFix\Model;


use FiloBlu\StockaFix\Model\Attributes\ReportAttribute;

/**
 * Class ReportOutput
 * @package FiloBlu\StockaFix\Model
 */
class ReportOutput implements \Magento\Framework\Api\Search\DocumentInterface
{
    /**
     * @var integer
     */
    protected $id;
    /**
     * @var array
     */
    protected $customAttributes = [];

    /**
     * @inheritDoc
     */
    public function getCustomAttribute($attributeCode)
    {
        if(isset($this->customAttributes[$attributeCode]))
        {
            return $this->customAttributes[$attributeCode];
        }
        return null;
    }

    /**
     * @inheritDoc
     */
    public function setCustomAttribute($attributeCode, $attributeValue)
    {
        $this->customAttributes[$attributeCode] = new ReportAttribute($attributeCode, $attributeValue) ;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getCustomAttributes()
    {
        return $this->customAttributes;
    }

    /**
     * @inheritDoc
     */
    public function setCustomAttributes(array $attributes)
    {
        $this->customAttributes = $attributes;
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @inheritDoc
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
}

