<?php

namespace FiloBlu\StockaFix\Model\Report;

use FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory;

/**
 * Class DataProvider
 * @package FiloBlu\StockaFix\Model\Report
 */
class DataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    /**
     * @var array|mixed
     */
    protected $loadedData;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $contactCollectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $contactCollectionFactory,
        array $meta = [],
        array $data = []
    )
    {
        $this->collection = $contactCollectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * @return array
     */
    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }

        $items = $this->collection->getItems();
        $this->loadedData = [];

        foreach ($items as $report) {

            $id = $report->getId();
            // report
            $this->loadedData[$id]['report']['report_id'] = $report->getData('report_id');
            $this->loadedData[$id]['report']['active'] = $report->getData('active');
            $this->loadedData[$id]['report']['name'] = $report->getData('name');
            $this->loadedData[$id]['report']['description'] = $report->getData('description');

            // schedule
            $this->loadedData[$id]['schedule']['schedule_frequency'] = $report->getData('schedule_frequency');
            $this->loadedData[$id]['schedule']['schedule_filename'] = $report->getData('schedule_filename');
            $this->loadedData[$id]['schedule']['active_schedule'] = $report->getData('active_schedule');
            $this->loadedData[$id]['schedule']['schedule_hour'] = $report->getData('schedule_hour');
            $this->loadedData[$id]['schedule']['schedule_minute'] = $report->getData('schedule_minute');

            // ftp
            $this->loadedData[$id]['ftp']['export_ftp'] = $report->getData('export_ftp');
            $this->loadedData[$id]['ftp']['ftp_host'] = $report->getData('ftp_host');
            $this->loadedData[$id]['ftp']['ftp_user'] = $report->getData('ftp_user');
            $this->loadedData[$id]['ftp']['ftp_psw'] = $report->getData('ftp_psw');
            $this->loadedData[$id]['ftp']['ftp_dir'] = $report->getData('ftp_dir');
            $this->loadedData[$id]['ftp']['ftp_filename'] = $report->getData('ftp_filename');


            // menu
            $this->loadedData[$id]['menu']['menu_label'] = $report->getData('menu_label');
            $this->loadedData[$id]['menu']['menu_show'] = $report->getData('menu_show');

            // receivers
            $this->loadedData[$id]['receivers']['receiver_emails'] = $report->getData('receiver_emails');
            $this->loadedData[$id]['receivers']['exclude_send_zero_row'] = $report->getData('exclude_send_zero_row');

            //date options
            $this->loadedData[$id]['date_options']['date_format'] = $report->getData('date_format');
            $this->loadedData[$id]['date_options']['date_locale'] = $report->getData('date_locale');

            // source
            $this->loadedData[$id]['source']['sql'] = $report->getData('sql');
            $this->loadedData[$id]['source']['id_label'] = $report->getData('id_label');
            $this->loadedData[$id]['source']['file_path'] = $report->getData('file_path');
            $this->loadedData[$id]['source']['mapping'] = (empty($report->getData('mapping'))) ? [] : json_decode($report->getData('mapping'));
            $this->loadedData[$id]['source']['status_pre_export'] = $report->getData('status_pre_export');
            $this->loadedData[$id]['source']['status_after_export'] = $report->getData('status_after_export');
            $this->loadedData[$id]['source']['status_active'] = $report->getData('status_active');
            $this->loadedData[$id]['source']['insert_csv_header'] = $report->getData('insert_csv_header');
        }


        return $this->loadedData;
    }
}
