<?php

namespace FiloBlu\StockaFix\Model;

use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Report
 * @package FiloBlu\StockaFix\Model
 */
class Report extends AbstractModel implements IdentityInterface,ReportInterface
{
    /**
     *
     */
    const CACHE_TAG = 'filoblu_stockafix_report';

    /**
     * @var string
     */
    protected $_cacheTag = 'filoblu_stockafix_report';

    /**
     * @var string
     */
    protected $_eventPrefix = 'filoblu_stockafix_report';

    /**
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @return array
     */
    public function getDefaultValues()
    {
        return [];
    }

    /**
     *
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\Report::class);
    }

    /**
     * @return array|mixed|string|null
     */
    public function getSql()
    {
        return $this->getData('sql');
    }

    /**
     * @return array|mixed|string|null
     */
    public function getName()
    {
        return $this->getData('name');
    }

    /**
     * @return array|mixed|null
     */
    public function getFileName()
    {
        return $this->getData('schedule_filename');
    }

}