<?php

namespace FiloBlu\StockaFix\Model\Export;

use FiloBlu\StockaFix\Model\ResourceModel\Report\Collection;
use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;
use Magento\InventoryApi\Api\Data\SourceItemInterface;

class ReportSource extends AbstractSource
{
    /**
     * @var Collection
     */
    private $reportCollection;

    /**
     * ReportSource constructor.
     * @param Collection $reportCollection
     */
    public function __construct(Collection $reportCollection)
    {
        $this->reportCollection = $reportCollection;
    }

    /**
     * Retrieve All options
     *
     * @return array
     */
    public function getAllOptions()
    {
        $output = [];

        /** @var \FiloBlu\StockaFix\Model\Report $report */
        foreach ($this->reportCollection->getItems() as $report)
        {
            $output[] = [
                'value' => $report->getId(),
                'label' => $report->getName()
                ];
        }

        return $output;
    }
}
