<?php
namespace FiloBlu\StockaFix\Controller\Adminhtml\Report;

use FiloBlu\StockaFix\Model\Report;
use FiloBlu\StockaFix\Helper\MailHelper;
use Magento\Framework\App\ResourceConnection;
use Zend_Db;
use FiloBlu\StockaFix\Model\Report\ProcessorInterfaceFactory;

/**
 * Class SendAction
 * @package FiloBlu\StockaFix\Controller\Adminhtml\Report
 */
class Sendreport extends \Magento\Backend\App\Action
{
    /**
     * @var MailHelper
     */
    private $mailHelper;

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var ProcessorInterfaceFactory
     */
    private $processorFactory;


    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param MailHelper $mailHelper
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        MailHelper $mailHelper,
        ResourceConnection $resourceConnection,
        ProcessorInterfaceFactory $processorFactory
    )
    {
        $this->mailHelper = $mailHelper;
        $this->resourceConnection = $resourceConnection;
        $this->processorFactory = $processorFactory;
        parent::__construct($context);
    }


    /**
     * @return mixed
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('report_id');

        if (!($report = $this->_objectManager->create(Report::class)->load($id))) {
            $this->messageManager->addErrorMessage(__('Unable to proceed. Report not found.'));
            $resultRedirect = $this->resultRedirectFactory->create();
            return $resultRedirect->setPath('*/*/edit', ['_current' => true, 'id' => $id]);
        }

        try{
            $processor = $this->processorFactory->create();
            $processor->process($report);
            $this->messageManager->addSuccessMessage(__('Your report has been sended !'));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Error while trying to send report: '.$e->getMessage()));
            $resultRedirect = $this->resultRedirectFactory->create();
            return $resultRedirect->setPath('*/*/edit', ['_current' => true, 'id' => $id]);
        }

        $resultRedirect = $this->resultRedirectFactory->create();
        return $resultRedirect->setPath('*/*/edit', ['_current' => true, 'id' => $id]);
    }
}
