<?php

namespace FiloBlu\StockaFix\Controller\Adminhtml\Report;

use FiloBlu\StockaFix\Model\Report;

/**
 * Class EditAction
 * @package FiloBlu\StockaFix\Controller\Adminhtml\Report
 */
class Edit extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resourceConnection;

    /**
     * @var \FiloBlu\StockaFix\Helper\ReportHelper
     */
    protected $reportHelper;

    /**
     * NewAction constructor.
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Magento\Framework\App\ResourceConnection $resourceConnection
     * @param \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->resourceConnection = $resourceConnection;
        $this->reportHelper = $reportHelper;
        parent::__construct($context);
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $this->_view->loadLayout();
        $this->_view->renderLayout();

        $reportDatas = [];

        try {

            $report = $this->_objectManager->create(Report::class);

            foreach (['report', 'schedule', 'ftp' , 'menu', 'receivers', 'date_options', 'source'] as $section) {
                $reportData = $this->getRequest()->getParam($section);

                if ($reportData === null) {
                    continue;
                }

                foreach($reportData as $key => $val) {
                    if(is_array($val)){
                        $reportData[$key] = json_encode($val);
                    }
                }

                if($section == 'schedule' && isset($reportData['schedule_type']) && isset($reportData['schedule_hour']) && isset($reportData['schedule_minute'])){
                   $scheduleFrequency = ['type' => $reportData['schedule_type'], 'hour' => $reportData['schedule_hour'], 'minute' => $reportData['schedule_minute']];
                   $reportData['schedule_frequency'] = json_encode($scheduleFrequency);
                }

                if (is_array($reportData)) {
                    $reportDatas = array_merge($reportDatas, $reportData);
                }
            }

            if (!empty($reportDatas)) {
                if(!isset($reportDatas['mapping'])){
                    $reportDatas['mapping'] = null;
                }
                $report->setData($reportDatas);
                $report->save();

                if (!empty($report->getSql())) {
                    $this->validateQuery($report);
                }

                $resultRedirect = $this->resultRedirectFactory->create();
                $this->messageManager->addSuccessMessage(__('Report saved correctly'));

                return $resultRedirect->setPath("*/*/index");
            }

        } catch (\Exception $e) {
            $resultRedirect = $this->resultRedirectFactory->create();
            $this->messageManager->addErrorMessage($e->getMessage());
            return $resultRedirect->setPath("*/*/index/");
        }
    }

    /**
     * @param $report
     * @throws \Exception
     */
    protected function validateQuery($report)
    {
        try {
            $sql = $report->getData('sql');
            $sqlView = $this->reportHelper->getReportSqlView($report);
            $connection = $this->resourceConnection->getConnection();
            $connection->query("SELECT * FROM ({$sql}) AS q LIMIT 1");
            $connection->query("CREATE OR REPLACE VIEW `{$sqlView}` AS $sql");
        }catch(\Exception $e) {
            throw new \Exception(__('Provided query is not valid. Reason ' . PHP_EOL. $e->getMessage() ));
        }
    }

}
