<?php

namespace FiloBlu\StockaFix\Console\Command;

use Exception;
use FiloBlu\StockaFix\Model\Report;
use FiloBlu\StockaFix\Model\Report\ProcessorInterfaceFactory;
use FiloBlu\StockaFix\Model\ReportInterface;
use FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ProcessCommand
 * @package FiloBlu\StockaFix\Console\Command
 */
class ProcessCommand extends Command
{
    /**
     * @var CollectionFactory
     */
    protected $reportCollectionFactory;

    /**
     * @var State
     */
    protected $state;

    /**
     * @var ProcessorInterfaceFactory
     */
    private $processorFactory;

    /**
     * ProcessCommand constructor.
     * @param CollectionFactory $reportCollectionFactory
     * @param State $state
     * @param ProcessorInterfaceFactory $processorFactory
     * @param string $name
     */
    public function __construct(
        CollectionFactory $reportCollectionFactory,
        State $state,
        ProcessorInterfaceFactory $processorFactory,
        $name = null
    ) {
        parent::__construct($name);
        $this->processorFactory = $processorFactory;
        $this->reportCollectionFactory = $reportCollectionFactory;
        $this->state = $state;
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName('filoblu:stockafix:process')
            ->setDescription('Process active reports')
            ->setDefinition([]);

        parent::configure();
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->setAreaCode(Area::AREA_ADMINHTML);
        } catch (Exception $e) {
            $output->writeln('Areacode was already set, skipping!');
        }

        $collection = $this->reportCollectionFactory->create();
        $this->connection = $collection->getResource()->getConnection();

        $reports = $collection
            ->addFieldToFilter('active', ['eq' => 1])
            ->getItems();
        /** @var Report\ProcessorInterface $processor */
        $processor = $this->processorFactory->create();

        /** @var ReportInterface $report */
        foreach ($reports as $report) {
            if (!$processor->canProcess($report)) {
                continue;
            }

            $output->write('<info>Processing ' . $report->getName() . ' ... </info>');

            try {
                $processor->process($report);
                $output->writeln('<info>done</info>');
            } catch (Exception $exception) {
                $output->writeln('<info>fail</info>');
            }
        }
    }
}
