<?php

namespace FiloBlu\StockaFix\Ui\Component\Listing;

/**
 * Class Columns
 * @package FiloBlu\StockaFix\Ui\Component\Listing
 */
class Columns extends \Magento\Ui\Component\Listing\Columns
{
    /**
     * @var int
     */
    const DEFAULT_COLUMNS_MAX_ORDER = 3;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    protected $request;

    /**
     * @var \Magento\Framework\View\Element\UiComponentFactory
     */
    protected $uiComponentFactory;
    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resourceConnection;

    /**
     * @var \FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory
     */
    protected $reportCollectionFactory;

    /**
     * @var \FiloBlu\StockaFix\Helper\ReportHelper
     */
    protected $reportHelper;
    /**
     * @var array
     */
    protected $mapping = [];

    /**
     * @var String
     */
    protected $dateFormat;

    /**
     * @var String
     */
    protected $dateLocale;


    /**
     * Columns constructor.
     * @param \Magento\Framework\View\Element\UiComponent\ContextInterface $context
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory
     * @param \Magento\Framework\App\ResourceConnection $resourceConnection
     * @param \FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory $reportCollectionFactory
     * @param \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper
     * @param array $components
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\UiComponent\ContextInterface $context,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        \FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory $reportCollectionFactory,
        \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper,
        array $components = [],
        array $data = []
    )
    {
        $this->uiComponentFactory = $uiComponentFactory;
        $this->request = $request;
        $this->resourceConnection = $resourceConnection;
        $this->reportCollectionFactory = $reportCollectionFactory;
        $this->reportHelper = $reportHelper;
        parent::__construct($context, $components, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function prepare()
    {
        $columnSortOrder = self::DEFAULT_COLUMNS_MAX_ORDER;

        $id = $this->request->getParam('id');

        /** @var \FiloBlu\StockaFix\Model\Report $report */
        $report = $this->reportCollectionFactory->create()->addFieldToFilter('report_id', ['eq', $id])->getFirstItem();
        $meta = $this->reportHelper->getReportMeta($report,true);
        $this->mapping = $this->reportHelper->getReportFieldMapping($report);

        $this->dateFormat = $report->getDateFormat();
        $this->dateLocale = $report->getDateLoacale();

        foreach ($meta as $attribute => $info) {
            if(isset($this->mapping[$attribute]['showInGrid']) && $this->mapping[$attribute]['showInGrid']==0){
                continue;
            }
            if (!isset($this->components[$attribute])) {
                $arguments = [
                    'data' => [
                        'config' =>  $this->getColumnFromMeta($info, $attribute, $columnSortOrder++)
                    ],
                    'context' => $this->context
                ];
                $column = $this->uiComponentFactory->create($attribute, 'column', $arguments);
                $column->prepare();
                $this->addComponent($attribute, $column);
            }
        }
        parent::prepare();
    }

    /**
     * @param $column
     * @param $attribute
     * @param $sortOrder
     * @return array
     */
    protected function getColumnFromMeta($column, $attribute, $sortOrder)
    {
        $dbType = $column['Type'];
        $label = $attribute;
        $filter = '';
        $elementTmpl = '';
        $type = '';
        $component = '';
        if(count($this->mapping)>0){
            if(isset($this->mapping[$attribute])){
                $label = $this->mapping[$attribute]['label'];
                $type = $this->mapping[$attribute]['type'];
                if($type == 'file') {
                    //$elementTmpl = 'FiloBlu_StockaFix/ui/grid/cells/download';
                    //$component = 'FiloBlu_StockaFix/js/grid/columns/download';
                    $elementTmpl = 'ui/grid/cells/link';
                    $component = 'Magento_Ui/js/grid/columns/link';
                }
            }
        }

        switch (true) {

            /* Numeric */
            case (stripos($dbType, 'int', 0) === 0):

                return [
                    'label' => $label,
//                    'dataType' => 'int',
                    'add_field' => false,
                    'visible' => 1,
                    'filter' => 'textRange',
                    'sortOrder' => $sortOrder,
                    'component' => 'Magento_Ui/js/grid/columns/column'
                ];
                /* Date */
            case (stripos($dbType, 'timestamp', 0) === 0):
            case (stripos($dbType, 'date', 0) === 0):
                return [
                    'label' => $label,
                    'dataType' => 'date',
                    'add_field' => false,
                    'visible' => 1,
                    'sortOrder' => $sortOrder,
                    'component' => 'Magento_Ui/js/grid/columns/date',
                    'storeTimeZone' => 'Europe/Rome',
                    'dateFormat' => $this->dateFormat,
                    'storeLocale' => $this->dateLocale,
                    'skipTimeZoneConversion' => false,
                    'options' => [
                        'dateFormat' => $this->dateFormat,
                        'storeLocale' => $this->dateLocale,
                    ],
                    'filter' => [
                        'filterType' => 'dateRange',
                        'templates' => [
                            'date' => [
                                'options' => [
                                    'dateFormat' => $this->dateFormat
                                ]
                            ]
                        ]
                    ]
                ];
            /* String */
            case (stripos($dbType, 'varchar', 0) === 0):
            default:

                $fieldMeta = [
                    'label' => $label,
                    'dataType' => 'text',
                    'add_field' => false,
                    'visible' => 1,
                    'filter' => 'text',
                    'sortOrder' => $sortOrder,
                    'component' => 'Magento_Ui/js/grid/columns/column'
                ];

                if($type == 'file'){
                    $fieldMeta['bodyTmpl'] = $elementTmpl;
                    $fieldMeta['component'] = $component;
                    $fieldMeta['link'] = $attribute;
                    $fieldMeta['sortable'] = false;
                }
                return $fieldMeta;
        }

    }

}
