<?php


namespace FiloBlu\StockaFix\Setup;

use \Magento\Framework\Setup\ModuleContextInterface;
use \Magento\Framework\Setup\SchemaSetupInterface;
use \Magento\Framework\Setup\UpgradeSchemaInterface;

/**
 * Class UpgradeSchema
 * @package FiloBlu\StockaFix\Setup
 */
class UpgradeSchema implements UpgradeSchemaInterface
{

    /**
     * @var string
     */
    const REPORTS_STATUS_TABLE = 'filoblu_stockafix_export_status';

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function upgrade(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    )
    {
        $version = $context->getVersion();

        if (version_compare($version, '1.0.1')  === -1) {
            $this->updateToOneZeroOne($setup, $context);
        }

        if (version_compare($version, '1.0.2') === -1) {
            $this->updateToOneZeroTwo($setup, $context);
        }

        if (version_compare($version, '1.0.3') === -1) {
            $this->updateToOneZeroThree($setup, $context);
        }

        if (version_compare($version, '1.0.4') === -1) {
            $this->updateToOneZeroFour($setup, $context);
        }

        if (version_compare($version, '1.0.5') === -1) {
            $this->updateToOneZeroFive($setup, $context);
        }

        if (version_compare($version, '1.0.6') === -1) {
            $this->updateToOneZeroSix($setup, $context);
        }

        if (version_compare($version, '1.0.7') === -1) {
            $this->updateToOneZeroSeven($setup, $context);
        }

        if (version_compare($version, '1.0.8') === -1) {
            $this->updateToOneZeroEight($setup, $context);
        }

        if (version_compare($version, '1.0.9') === -1) {
            $this->updateToOneZeroNine($setup, $context);
        }

        if (version_compare($version, '1.0.10') === -1) {
            $this->updateToOneZeroTen($setup, $context);
        }
    }

    /**
     * Upgrade to version 1.0.1
     *
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroOne(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'menu_show' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'comment' => 'Show in menu',
                    'default' => false
                ],
                'menu_label' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Label in menu',
                ],
                'receiver_emails' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Receivers email',
                    'length' => '64k'
                ],
                'schedule_frequency' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Schedule frequency'
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * Upgrade to version 1.0.2
     *
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroTwo(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'active' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'comment' => 'Enable',
                    'default' => false
                ],
                'id_label' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Label id',
                ]

            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * Upgrade to version 1.0.3
     *
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroThree(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'driver_settings' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Driver Settings'
                ],
                'driver' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Driver',
                ],
                'schedule_filename' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Schedule Filename',
                ]


            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroFour(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'mapping' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Mapping',
                    'length' => '64k'
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroFive(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'file_path' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'File Path'
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroSix(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'active_schedule' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'comment' => 'Enable',
                    'default' => false
                ],
                'schedule_hour' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Schedule Hour'
                ],
                'schedule_minute' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Schedule Minute'
                ],
                'schedule_type' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Schedule Type'
                ],
                'schedule_last_execute' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                    'nullable' => true,
                    'comment' => 'Schedule Last Execute Time'
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroSeven(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'exclude_send_zero_row' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'comment' => 'Not Send Email For Empty Report',
                    'default' => false
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroEight(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'date_format' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => false,
                    'comment' => 'Date format for date fields'
                ],
                'date_locale' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => false,
                    'comment' => 'Date locale for date fields'
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function updateToOneZeroNine(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        if (!$setup->tableExists(self::REPORTS_STATUS_TABLE)) {
            $table = $setup->getConnection()->newTable(
                $setup->getTable(self::REPORTS_STATUS_TABLE)
            )
                ->addColumn(
                    'status_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    [
                        'identity' => TRUE,
                        'nullable' => FALSE,
                        'primary' => TRUE,
                        'unsigned' => TRUE,
                    ],
                    'Report Status ID'
                )
                ->addColumn(
                    'report_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    [
                        'nullable' => FALSE,
                        'unsigned' => TRUE,
                    ],
                    'Report ID'
                )
                ->addColumn(
                    'reportoutput_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    [
                        'nullable' => FALSE,
                        'unsigned' => TRUE,
                    ],
                    'Reportoutput ID'
                )
                ->addColumn(
                    'created_at',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                    null,
                    [
                        'nullable' => false,
                        'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT
                    ],
                    'Created At'
                )
                ->addColumn(
                    'exported_at',
                    \Magento\Framework\DB\Ddl\Table::TYPE_DATETIME,
                    null,
                    [
                        'nullable' => true
                    ],
                    'Exported At'
                )
                ->addColumn(
                    'status',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    [
                        'nullable' => true
                    ],
                    'Report Status'
                );
            $setup->getConnection()->createTable($table);
        }

        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);
        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'status_active' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'comment' => 'Enable export by status',
                    'default' => false
                ],
                'status_pre_export' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Status value pre export'
                ],
                'status_after_export' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Status value after export'
                ]
            ];

            $connection = $setup->getConnection();
            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
        $setup->endSetup();
    }

    public function updateToOneZeroTen(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $tableName = $setup->getTable(InstallSchema::REPORTS_TABLE);

        if ($setup->getConnection()->isTableExists(InstallSchema::REPORTS_TABLE) == true) {

            $columns = [
                'insert_csv_header' => [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'comment' => 'insert header in report csv',
                    'default' => false
                ]
            ];

            $connection = $setup->getConnection();

            foreach ($columns as $name => $definition) {
                $connection->addColumn($tableName, $name, $definition);
            }
        }
    }
}
