<?php

namespace FiloBlu\StockaFix\Model\ResourceModel;

use Exception;
use FiloBlu\StockaFix\Helper\ReportHelper;
use FiloBlu\StockaFix\Model\ReportOutput;
use FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\DB\Select;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Psr\Log\LoggerInterface;
use Zend_Db;
use Zend_Db_Statement_Exception;

/**
 * Class ReportOutputCollection
 * @package FiloBlu\StockaFix\Model\ResourceModel
 */
class ReportOutputCollection extends AbstractCollection implements SearchResultInterface
{
    /**
     * @var int
     */
    protected $totalCount;

    /**
     * @var
     */
    protected $items = [];

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var
     */
    protected $aggregations;

    /**
     * @var
     */
    protected $searchCriteria;

    /**
     * @var Report\CollectionFactory
     */
    protected $reportCollectionFactory;

    /**
     * @var ReportHelper
     */
    protected $reportHelper;

    /**
     * @var \FiloBlu\StockaFix\Model\Report
     */
    protected $report;

    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;

    /**
     * ReportOutputCollection constructor.
     * @param EntityFactoryInterface $entityFactory
     * @param LoggerInterface $logger
     * @param FetchStrategyInterface $fetchStrategy
     * @param ManagerInterface $eventManager
     * @param Report\CollectionFactory $reportCollectionFactory
     * @param ReportHelper $reportHelper
     * @param RequestInterface $request
     * @param ResourceConnection $resourceConnection
     * @param AdapterInterface|null $connection
     * @param AbstractDb|null $resource
     * @throws Exception
     */
    public function __construct(
        EntityFactoryInterface $entityFactory,
        LoggerInterface $logger,
        FetchStrategyInterface $fetchStrategy,
        ManagerInterface $eventManager,
        CollectionFactory $reportCollectionFactory,
        ReportHelper $reportHelper,
        RequestInterface $request,
        ResourceConnection $resourceConnection,
        AdapterInterface $connection = null,
        AbstractDb $resource = null
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->reportHelper = $reportHelper;
        $this->_eventManager = $eventManager;
        $this->_resource = $resource;
        $this->request = $request;
        $this->reportCollectionFactory = $reportCollectionFactory;
        $collection = $this->reportCollectionFactory->create();

        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $connection,
            $collection->getResource()
        );
    }

    /**
     * @return string
     */
    public function getMainTable()
    {
        return $this->_mainTable;
    }

    /**
     * @param bool $printQuery
     * @param bool $logQuery
     * @return $this|AbstractCollection
     * @throws Zend_Db_Statement_Exception
     */
    public function load($printQuery = false, $logQuery = false)
    {
        $this->items = [];

        $offset = ($this->_pageSize * ($this->_curPage - 1));
        $page = $this->_pageSize;

        $this->totalCount = $this->_select->query()->rowCount();

        $this->_select->limit($page, $offset);

        foreach ($this->_orders as $column => $order) {
            $this->_select->order("{$column} {$order}");
        }

        $result = $this->_select->query()->fetchAll(Zend_Db::FETCH_ASSOC);

        foreach ($result as $item) {
            $t = new  ReportOutput();
            foreach ($item as $k => $v) {
                if ($k === 'reportoutput_id') {
                    $t->setId($v);
                }
                $t->setCustomAttribute($k, $v);
            }

            $this->_items[] = $t;
        }

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setItems(array $items = null)
    {
        $this->items = $items;
    }

    /**
     * @return AggregationInterface
     */
    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * @param AggregationInterface $aggregations
     * @return $this
     */
    public function setAggregations($aggregations)
    {
        $this->aggregations = $aggregations;
        return $this;
    }

    /**
     * @return SearchCriteriaInterface
     */
    public function getSearchCriteria()
    {
        return $this->searchCriteria;
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return $this|SearchResultInterface
     */
    public function setSearchCriteria(SearchCriteriaInterface $searchCriteria)
    {
        $this->searchCriteria = $searchCriteria;
        return $this;
    }

    /**
     * @return int
     * @throws Zend_Db_Statement_Exception
     */
    public function getTotalCount()
    {
        if ($this->totalCount === null) {
            $this->totalCount = $this->_select->query()->rowCount();
        }

        return $this->totalCount;
    }

    /**
     * @param int $totalCount
     * @return $this|SearchResultInterface
     */
    public function setTotalCount($totalCount)
    {
        $this->totalCount = $totalCount;
        return $this;
    }

    /**
     * @return array
     * @throws LocalizedException
     */
    public function getAllIds()
    {
        $idsSelect = clone $this->getSelect();
        $idsSelect->reset(Select::ORDER);
        $idsSelect->reset(Select::LIMIT_COUNT);
        $idsSelect->reset(Select::LIMIT_OFFSET);
        $idsSelect->reset(Select::COLUMNS);
        $idsSelect->columns($this->getResource()->getIdFieldName(), 'main_table');
    }

    /**
     * @return AbstractDb|null
     */
    public function getResource()
    {
        return $this->_resource;
    }

    /**
     * @throws Exception
     */
    protected function _construct()
    {
        // TODO : make it in a safer way
        $this->items = [];
        $collection = $this->reportCollectionFactory->create();
        $this->_resource = $collection->getResource();
        $this->report = $collection
            ->addFieldToFilter('report_id', ['eq', $this->request->getParam('id')])
            ->getFirstItem();
        $this->_mainTable = $this->reportHelper->getReportSqlView($this->report);
        $this->setConnection($collection->getConnection());
        $this->setMainTable($this->_mainTable);
    }

    /**
     * @param string $table
     * @return $this|AbstractCollection
     */
    public function setMainTable($table)
    {
        $this->_mainTable = $table;
        return $this;
    }

    /**
     * @return $this
     * @throws Exception
     */
    protected function _initInitialFieldsToSelect()
    {
        $meta = $this->reportHelper->getReportMeta($this->report , true);

        foreach ($meta as $attribute => $info) {
            $this->addFieldToSelect($attribute);
        }

        return $this;
    }

    /**
     * @return $this|AbstractCollection|void
     */
    protected function _initSelect()
    {
        $this->_select = $this->reportCollectionFactory->create()->getConnection()->select();
        parent::_initSelect();
        return $this;
    }
}
