<?php

namespace FiloBlu\StockaFix\Model;

use Exception;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Filesystem\Io\IoInterface;

/**
 * Class ExportDriverProvider
 * @package FiloBlu\StockaFix\Model
 */
class ExportDriverProvider implements ExportDriverProviderInterface, OptionSourceInterface
{
    /**
     * @var array
     */
    private $providers;

    /**
     * ExportDriverProvider constructor.
     * @param array $providers
     */
    public function __construct(array $providers)
    {
        $this->providers = $providers;
    }

    /**
     * @return array
     */
    public function getDrivers(): array
    {
        return $this->providers;
    }

    /**
     * @param $name
     * @return IoInterface
     * @throws Exception
     */
    public function getDriver($name): IoInterface
    {
        if (!isset($this->providers[$name])) {
            throw new Exception("Could not find driver with name \"{$name}\"");
        }

        return $this->providers[$name];
    }

    public function toOptionArray()
    {
        $output = [];

        foreach ($this->providers as $name => $provider)
        {
            $output[] = ['label' => __($name), 'value' => $name];
        }

        return $output;
    }
}