<?php

declare(strict_types=1);

namespace FiloBlu\StockaFix\Model\Export;

use Exception;
use FiloBlu\StockaFix\Model\ReportOutput;
use InvalidArgumentException;
use Magento\Eav\Model\Entity\Attribute;
use Magento\Eav\Model\Entity\AttributeFactory;
use Magento\Framework\Data\Collection;
use Magento\ImportExport\Model\Export\Factory as CollectionFactory;

/**
 * @api
 */
class AttributeCollectionProvider
{
    /**
     * @var Collection
     */
    private $collection;

    /**
     * @var AttributeFactory
     */
    private $attributeFactory;

    /**
     * @param CollectionFactory $collectionFactory
     * @param AttributeFactory $attributeFactory
     * @throws InvalidArgumentException
     */
    public function __construct(
        CollectionFactory $collectionFactory,
        AttributeFactory $attributeFactory
    )
    {
        $this->collection = $collectionFactory->create(Collection::class);
        $this->attributeFactory = $attributeFactory;
    }

    /**
     * @return Collection
     * @throws Exception
     */
    public function get(): Collection
    {
        if (count($this->collection) === 0) {

            /** @var Attribute $statusIdAttribute */
            $statusIdAttribute = $this->attributeFactory->create();
            $statusIdAttribute->setId('report');
            $statusIdAttribute->setDefaultFrontendLabel('Report');
            $statusIdAttribute->setAttributeCode('report');
            $statusIdAttribute->setBackendType('int');
            $statusIdAttribute->setFrontendInput('select');
            $statusIdAttribute->setSourceModel(\FiloBlu\StockaFix\Model\Export\ReportSource::class);
            $this->collection->addItem($statusIdAttribute);


        }

        return $this->collection;
    }
}
