<?php

namespace FiloBlu\StockaFix\Model\Config\Source;

use Exception;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Filesystem\Io\IoInterface;

/**
 * Class ScheduleHour
 * @package FiloBlu\StockaFix\Model
 */
class ScheduleHour implements OptionSourceInterface
{

    public function toOptionArray()
    {
        $output = [];

        for($i = 0; $i < 24; $i++){
            $output[] = ['label' => str_pad($i, 2, '0', STR_PAD_LEFT), 'value' => str_pad($i, 2, '0', STR_PAD_LEFT)];
        }

        return $output;
    }
}
