<?php
namespace FiloBlu\StockaFix\Helper;

use FiloBlu\StockaFix\Model\Report;
use FiloBlu\StockaFix\Model\ReportFactory;

/**
 * Class ReportHelper
 */
class ReportHelper
{

    const STOCKAFIX_DOWNLOAD_CONTROLLER = 'filoblu_stockafix/download/index';

    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resourceConnection;
    /**
     * @var ReportFactory
     */
    protected $reportFactory;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * ReportHelper constructor.
     * @param \Magento\Framework\App\ResourceConnection $resourceConnection
     */
    public function __construct(
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        ReportFactory $reportFactory,
        \Magento\Framework\UrlInterface $urlBuilder
    )
    {
        $this->resourceConnection= $resourceConnection;
        $this->reportFactory = $reportFactory;
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @param \FiloBlu\StockaFix\Model\Report $report
     * @return string
     * @throws \Exception
     */
    public function getReportSqlView(\FiloBlu\StockaFix\Model\Report $report)
    {
        if(!($id = $report->getId()))
        {
            throw new \Exception(__('Report has no id'));
        }

        return "filoblu_stockafix_view_{$id}";
    }

    /**
     * @param \FiloBlu\StockaFix\Model\Report $report
     * @param $removeReportId
     * @return array
     * @throws \Exception
     */
    public function getReportMeta(\FiloBlu\StockaFix\Model\Report $report , $removeReportId)
    {
        //TODO:  modify by select - \FiloBlu\StockaFix\Model\ResourceModel\ReportOutputCollection::_initInitialFieldsToSelect & \FiloBlu\StockaFix\Ui\Component\Listing\Columns::prepare
        $view = $this->getReportSqlView($report);
        $rawMeta = $this->resourceConnection->getConnection()->query("DESCRIBE `{$view}`")->fetchAll();

        $meta = [];
        foreach ($rawMeta as $info) {
            $meta[$info['Field']] = $info;
        }

        if ($removeReportId) {
            unset($meta['reportoutput_id']);
        }
        return $meta;
    }

    /**
     * @param \Magento\Framework\App\RequestInterface $request
     * @param $param
     * @return Report
     */
    public function getReportFromRequest(\Magento\Framework\App\RequestInterface $request, $param) {
        $id = $request->getParam($param);
        return $this->reportFactory->create()->load($id);
    }

    /**
     * @param $report
     * @return array
     */
    public function getReportFieldMapping($report) {
        $maps = [];
        if(!empty($report['mapping'])){
            $mapping = json_decode($report['mapping'], true);
            $tempMap = [];
            foreach ($mapping['mapping'] as $map) {
                $tempMap[$map['field']] = $map;
            }
            $maps = $tempMap;
        }
        return $maps;
    }

    /**
     * @param $mapping
     * @param $attribute
     * @param $val
     * @param array $params
     * @return mixed|string
     */
    public function getMappedValue($mapping, $attribute, $val, $params = []) {
        if(count($mapping)>0){
            if(isset($mapping[$attribute])){
                if($mapping[$attribute]['type'] == 'file') {
                    $temp = str_replace('[','', $val);
                    $temp = str_replace(']','', $temp);
                    $params = array_merge($params,['file' => $temp]);
                    $url = $this->urlBuilder->getUrl(self::STOCKAFIX_DOWNLOAD_CONTROLLER, $params);
                    $val = $url;
                }
            }
        }

        return $val;
    }
}
