<?php
namespace FiloBlu\StockaFix\Block\Adminhtml\Report\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;


/**
 * Class SendButton
 */
class SendButton extends GenericButton implements ButtonProviderInterface
{
    /**
     * @return array
     */
    public function getButtonData()
    {
        $data = [];
        if ($this->getId()) {
            $data = [
                'label' => __('Send report'),
                'class' => 'send',
                'on_click' => 'deleteConfirm(\''
                    . __('Are you sure you want to send this report ?')
                    . '\', \'' . $this->getSendUrl() . '\')',
                'sort_order' => 50,
            ];
        }
        return $data;
    }

    /**
     * @return int|null
     */
    public function getId()
    {
        $reportId = $this->request->getParam('id');
        return $reportId ? $reportId : null;
    }

    /**
     * @return string
     */
    public function getSendUrl()
    {
        return $this->getUrl('*/*/sendreport', ['report_id' => $this->getId()]);
    }
}
