/**
 * @api
 */
define([
    './download',
    'mageUtils'
], function (Column, utils) {
    'use strict';

    return Column.extend({
        defaults: {
            link: 'link',
            bodyTmpl: 'FiloBlu_StockaFix/ui/grid/cells/download'
        },

        /**
         * Returns link to given record.
         *
         * @param {Object} record - Data to be preprocessed.
         * @returns {String}
         */
        getLink: function (record) {
            return utils.nested(record, this.link);
        },

        /**
         * Check if link parameter exist in record.
         * @param {Object} record - Data to be preprocessed.
         * @returns {Boolean}
         */
        isLink: function (record) {
            return !!utils.nested(record, this.link);
        }
    });
});
