define([
    'Magento_Ui/js/form/element/abstract',
    'Magento_Ui/js/lib/view/utils/async',
    'FiloBlu_StockaFix/js/ace.min'
], function (Abstract, $) {
    'use strict';

    return Abstract.extend({
        editor: null,
        defaults: {
            template: 'ui/form/field',
            elementTmpl: 'FiloBlu_StockaFix/ui/form/element/ace',
            showSpinner: false,
            loading: false
        },
        /**
         * Initializes component, invokes initialize method of Abstract class.
         *
         *  @returns {Object} Chainable.
         */
        initialize: function () {

            this._super();
            let self = this;

            ace.require('ace/lib/oop');
            ace.require('ace/mode/text_highlight_rules');

            $.async('.filoblu_stockafix_ace_editor', this, function (node) {

                let baseUrl = require.s.contexts._.config.baseUrl;

                ace.config.set('basePath', `${baseUrl}FiloBlu_StockaFix/js/`);
                ace.config.set('modePath', `${baseUrl}FiloBlu_StockaFix/js/`);
                ace.config.set('themePath',`${baseUrl}FiloBlu_StockaFix/js/`);
                ace.config.set('workerPath',`${baseUrl}FiloBlu_StockaFix/js/`);
                ace.config.set('suffix', '.min.js');

                self.editor = ace.edit(node, {
                    mode: 'ace/mode/sql',
                    minLines: 35,
                    maxLines: 5000
                });

                self.editor.getSession().setValue(self.value());
                self.editor.on('change', function () {
                    self.value(self.editor.getSession().getValue());
                })

            }.bind(this));
            return this;
        }
    })
});