<?php

namespace FiloBlu\StockaFix\Ui\DataProvider;

use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\ReportingInterface;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\App\RequestInterface;

/**
 * Class ReportDataProvider
 * @package FiloBlu\StockaFix\Ui\DataProvider
 */
class ReportDataProvider extends \Magento\Framework\View\Element\UiComponent\DataProvider\DataProvider
{
    /**
     * @var \FiloBlu\StockaFix\Helper\ReportHelper
     */
    protected $reportHelper;

    /**
     * ReportDataProvider constructor.
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param ReportingInterface $reporting
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param RequestInterface $request
     * @param FilterBuilder $filterBuilder
     * @param \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        ReportingInterface $reporting,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        RequestInterface $request,
        FilterBuilder $filterBuilder,
        \FiloBlu\StockaFix\Helper\ReportHelper $reportHelper,
        array $meta = [],
        array $data = []
    )
    {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $reporting, $searchCriteriaBuilder, $request, $filterBuilder, $meta, $data);
        $this->reportHelper = $reportHelper;
    }

    /**
     * @return void
     */
    protected function prepareUpdateUrl()
    {
        if (!isset($this->data['config']['filter_url_params'])) {
            return;
        }
        foreach ($this->data['config']['filter_url_params'] as $paramName => $paramValue) {
            if ('*' == $paramValue) {
                $paramValue = $this->request->getParam($paramName);
            }
            if ($paramValue) {

                $this->data['config']['update_url'] = sprintf(
                    '%s%s/%s/',
                    $this->data['config']['update_url'],
                    $paramName,
                    $paramValue
                );

                if( $paramName === 'id')
                {
                    continue;
                }

                $this->addFilter(
                    $this->filterBuilder->setField($paramName)->setValue($paramValue)->setConditionType('eq')->create()
                );
            }
        }
    }

    /**
     * @return array
     */
    public function getData()
    {
        $id = $this->request->getParam('id');
        $report = $this->reportHelper->getReportFromRequest($this->request,'id');
        $mapping = $this->reportHelper->getReportFieldMapping($report);
        $data = parent::getData();
        foreach ($data['items'] as $k => $v) {
            $data['items'][$k]['report_id'] = $id;
            foreach ($v as $attribute => $value){
                $data['items'][$k][$attribute] = $this->reportHelper->getMappedValue($mapping,$attribute,$value,['id' => $id]);
            }
        }
        return $data;
    }
}
