<?php

namespace FiloBlu\StockaFix\Model\Reportoutput;

use FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory;

/**
 * Class DataProvider
 * @package FiloBlu\StockaFix\Model\Reportoutput
 */
class DataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $contactCollectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $contactCollectionFactory,
        array $meta = [],
        array $data = []
    )
    {
        $this->collection = $contactCollectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * @return array
     */
    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }

        $items = $this->collection->getItems();
        $this->loadedData = [];

        foreach ($items as $report) {

            $id = $report->getId();
            // report
            $this->loadedData[$id]['report']['report_id'] = $report->getData('report_id');
            $this->loadedData[$id]['report']['active'] = $report->getData('active');
            $this->loadedData[$id]['report']['name'] = $report->getData('name');
            $this->loadedData[$id]['report']['description'] = $report->getData('description');

            // schedule
            $this->loadedData[$id]['schedule']['schedule_frequency'] = $report->getData('schedule_frequency');
            $this->loadedData[$id]['schedule']['schedule_filename'] = $report->getData('schedule_filename');
            $this->loadedData[$id]['schedule']['active_schedule'] = $report->getData('active_schedule');

            // ftp
            $this->loadedData[$id]['ftp']['export_ftp'] = $report->getData('export_ftp');
            $this->loadedData[$id]['ftp']['ftp_host'] = $report->getData('ftp_host');
            $this->loadedData[$id]['ftp']['ftp_user'] = $report->getData('ftp_user');
            $this->loadedData[$id]['ftp']['ftp_psw'] = $report->getData('ftp_psw');
            $this->loadedData[$id]['ftp']['ftp_dir'] = $report->getData('ftp_dir');
            $this->loadedData[$id]['ftp']['ftp_filename'] = $report->getData('ftp_filename');


            // menu
            $this->loadedData[$id]['menu']['menu_label'] = $report->getData('menu_label');

            // receivers
            $this->loadedData[$id]['receivers']['receiver_emails'] = $report->getData('receiver_emails');
            $this->loadedData[$id]['receivers']['exclude_send_zero_row'] = $report->getData('exclude_send_zero_row');

            // source
            $this->loadedData[$id]['source']['sql'] = $report->getData('sql');
            $this->loadedData[$id]['source']['id_label'] = $report->getData('id_label');

        }

        return $this->loadedData;
    }
}
