<?php

namespace FiloBlu\StockaFix\Model\Report;

use FiloBlu\StockaFix\Model\ReportInterface;
use RuntimeException;

/**
 * Interface ProcessorInterface
 * @package FiloBlu\StockaFix\Model\Report
 */
interface ProcessorInterface
{
    public function canProcess(ReportInterface $report): bool;

    /**
     * @throws RuntimeException
     */
    public function process(ReportInterface $report) : ReportStatusInterface;
}
