<?php

namespace FiloBlu\StockaFix\Model\Export;

use Exception;
use FiloBlu\StockaFix\Helper\ReportHelper;
use FiloBlu\StockaFix\Model\ResourceModel\Report\CollectionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\ImportExport\Model\Export\AbstractEntity;
use Magento\ImportExport\Model\Export\Factory;
use Magento\ImportExport\Model\ResourceModel\CollectionByPagesIteratorFactory;
use Magento\Store\Model\StoreManagerInterface;
use Zend_Db;

/**
 * Class Report
 * @package FiloBlu\StockaFix\Model\Export
 */
class Report extends AbstractEntity
{
    /**
     * @var AttributeCollectionProvider
     */
    private $attributeCollectionProvider;
    /**
     * @var CollectionFactory
     */
    private $reportCollectionFactory;
    /**
     * @var ReportHelper
     */
    private $reportHelper;
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     * @param Factory $collectionFactory
     * @param AttributeCollectionProvider $attributeCollectionProvider
     * @param CollectionByPagesIteratorFactory $resourceColFactory
     * @param CollectionFactory $reportCollectionFactory
     * @param ReportHelper $reportHelper
     * @param ResourceConnection $resourceConnection
     * @param array $data
     * @throws Exception
     * @SuppressWarnings(PHPMD.NPathComplexity)
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        Factory $collectionFactory,
        AttributeCollectionProvider $attributeCollectionProvider,
        CollectionByPagesIteratorFactory $resourceColFactory,
        CollectionFactory $reportCollectionFactory,
        ReportHelper $reportHelper,
        ResourceConnection $resourceConnection,
        array $data = []
    ) {
        $data['attribute_collection'] = $attributeCollectionProvider->get();
        parent::__construct($scopeConfig, $storeManager, $collectionFactory, $resourceColFactory, $data);
        $this->attributeCollectionProvider = $attributeCollectionProvider;
        $this->reportCollectionFactory = $reportCollectionFactory;
        $this->reportHelper = $reportHelper;
        $this->resourceConnection = $resourceConnection;

    }

    public function getAttributeCollection()
    {
        return $this->attributeCollectionProvider->get();
    }

    public function exportItem($item)
    {
    }

    public function getEntityTypeCode()
    {
        return 'filoblu_stockafix_report';
    }

    public function export()
    {
        $report = $this->reportCollectionFactory->create()
            ->addFieldToFilter(
                'report_id',
                $this->_parameters['export_filter']['report']
            )->getFirstItem();
//        $this->setFileName($report->getData('menu_label'));
        $sqlView = $this->reportHelper->getReportSqlView($report);
        $this->meta = $this->reportHelper->getReportMeta($report,true);

        $this->getWriter()->setHeaderCols(array_keys($this->meta));

        $connection = $this->resourceConnection->getConnection();

        foreach ($connection->fetchAll("SELECT * FROM {$sqlView}", [], Zend_Db::FETCH_ASSOC) as $row) {
            unset($row['reportoutput_id']);
            $this->getWriter()->writeRow($row);
        }

        return $this->getWriter()->getContents();
    }

    public function setParameters(array $parameters)
    {
        //$this->setFileName('test_');
        return parent::setParameters($parameters);
    }

    protected function _getEntityCollection()
    {
    }

    protected function _getExportAttributeCodes()
    {
        return ['report'];
    }

    protected function _getHeaderColumns()
    {
        return ['Report Name'];
    }


}
