<?php

namespace FiloBlu\StockaFix\Model\Attributes;
use Magento\Framework\Api\AttributeInterface;

/**
 * Class ReportAttribute
 * @package FiloBlu\StockaFix\Model\Attributes
 */
class ReportAttribute implements AttributeInterface
{
    /**
     * @var
     */
    protected $attributeCode;

    /**
     * @var
     */
    protected $value;

    /**
     * ReportAttribute constructor.
     * @param $attributeCode
     * @param $value
     */
    public function __construct($attributeCode, $value)
    {
        $this->attributeCode = $attributeCode;
        $this->value = $value;
    }

    /**
     * @inheritDoc
     */
    public function getAttributeCode()
    {
        return $this->attributeCode;
    }

    /**
     * @inheritDoc
     */
    public function setAttributeCode($attributeCode)
    {
        $this->attributeCode = $attributeCode;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @inheritDoc
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }
}