<?php

namespace FiloBlu\StockaFix\Helper;

/**
 * Class MailHelper
 * @package FiloBlu\StockaFix\Helper
 */
class MailHelper
{

    /**
     * @var \FiloBlu\StockaFix\Mail\Template\TransportBuilder
     */
    protected $transportBuilder;

    /**
     * @var \Magento\Framework\Translate\Inline\StateInterface
     */
    protected $inlineTranslation;

    /**
     * @var \Magento\Framework\Mail\Template\SenderResolverInterface
     */
    protected $sendersResolver;


    /**
     * @param \FiloBlu\StockaFix\Mail\Template\TransportBuilder $transportBuilder
     * @param \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation
     * @param \Magento\Framework\Mail\Template\SenderResolverInterface $sendersResolver
     */
    public function __construct(
        \FiloBlu\StockaFix\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Framework\Mail\Template\SenderResolverInterface $sendersResolver
    )
    {
        $this->transportBuilder = $transportBuilder;
        $this->inlineTranslation = $inlineTranslation;
        $this->sendersResolver = $sendersResolver;
    }

    /**
     *
     * @param array $to ['email' => "email@sender.com", 'name' => 'Name of Sender'];
     * @param string $templateIdentifier
     * @param array $templateVars ['report_name' => '...', 'report_count' => '...']
     * @param array $attachments ['file1.csv', 'file2.csv']
     *
     * @throws \Magento\Framework\Exception\MailException
     */
    public function sendReportMail(array $to, $attachments = [], $templateVars = [], $templateIdentifier = 'filoblu_stockafix_report_template')
    {
        $templateOptions = [
            'area' => \Magento\Framework\App\Area::AREA_ADMINHTML,
            'store' => \Magento\Store\Model\Store::DEFAULT_STORE_ID
        ];

        $from = $this->sendersResolver->resolve('general');

        $this->inlineTranslation->suspend();
        $transport = $this->transportBuilder
            ->setTemplateIdentifier($templateIdentifier)
            ->setTemplateOptions($templateOptions)
            ->setTemplateVars($templateVars)
            ->setFrom($from)
            ->addTo($to)
            ->getTransport();

        $html = 'Report: ' . $templateVars['report_name'] . ' <br/>Rows: ' . $templateVars['report_count'];
        $bodyMessage = new \Zend\Mime\Part($html);
        $bodyMessage->type = 'text/html';

        $attachmentFileName = "report.csv";
        if($templateVars['report_filename']) {
            $attachmentFileName = $templateVars['report_filename'].".csv";
        }

        foreach ($attachments as $attachment) {
            $attachmentElement = $this->addAttachment(file_get_contents($attachment), $attachmentFileName);
            //To Refact
            $attachmentElement->type = mime_content_type($attachment);
            $bodyPart = new \Zend\Mime\Message();
            $bodyPart->setParts(array($bodyMessage,$attachmentElement));
            $transport->getMessage()->setBody($bodyPart);
        }

        $transport->sendMessage();
        $this->inlineTranslation->resume();
    }

    /**
     * @param Api\AttachmentInterface $attachment
     */
    public function addAttachment($pdfString,$filename)
    {
        $attachment = new \Zend\Mime\Part($pdfString);
        $attachment->type = \Zend_Mime::TYPE_OCTETSTREAM;
        $attachment->disposition = \Zend_Mime::DISPOSITION_ATTACHMENT;
        $attachment->encoding = \Zend_Mime::ENCODING_BASE64;
        $attachment->filename = $filename;
        return $attachment;
    }
}
