<?php

namespace FiloBlu\StockaFix\Controller\Adminhtml\ReportOutput;

/**
 * Class Index
 * @package FiloBlu\StockaFix\Controller\Adminhtml\ReportOuput
 */
class Index extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var \FiloBlu\StockaFix\Model\ReportFactory
     */
    protected $reportFactory;

    /**
     * Index constructor.
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \FiloBlu\StockaFix\Model\ReportFactory $reportFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \FiloBlu\StockaFix\Model\ReportFactory $reportFactory
    )
    {
        $this->reportFactory = $reportFactory;
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
    }

    /**
     * Execute view action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $reportId = $this->getRequest()->getParam('id');

        $report = $this->reportFactory->create()->load($reportId);
        $page = $this->resultPageFactory->create();
        $page->getConfig()->getTitle()->set($report->getName());
        return $page;
    }
}
